/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.math;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.opensearch.sql.calcite.utils.MathUtils;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class ModFunction
extends ImplementorUDF {
    public ModFunction() {
        super(new ModImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.FORCE_NULLABLE);
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_NUMERIC;
    }

    public static class ModImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression dividend = translatedOperands.get(0);
            Expression divisor = translatedOperands.get(1);
            RelDataType dividendType = ((RexNode)call.getOperands().get(0)).getType();
            RelDataType divisorType = ((RexNode)call.getOperands().get(1)).getType();
            if (SqlTypeFamily.INTEGER.contains(dividendType) && SqlTypeFamily.INTEGER.contains(divisorType)) {
                return Expressions.call(ModImplementor.class, (String)"integralMod", (Expression[])new Expression[]{Expressions.convert_((Expression)dividend, Number.class), Expressions.convert_((Expression)divisor, Number.class)});
            }
            return Expressions.call(ModImplementor.class, (String)"floatingMod", (Expression[])new Expression[]{Expressions.convert_((Expression)dividend, Number.class), Expressions.convert_((Expression)divisor, Number.class)});
        }

        public static Number integralMod(Number dividend, Number divisor) {
            if (divisor.doubleValue() == 0.0) {
                return null;
            }
            long l0 = dividend.longValue();
            long l1 = divisor.longValue();
            long result = l0 % l1;
            return MathUtils.coerceToWidestIntegralType(dividend, divisor, result);
        }

        public static Number floatingMod(Number dividend, Number divisor) {
            if (divisor.doubleValue() == 0.0) {
                return null;
            }
            BigDecimal b0 = new BigDecimal(dividend.toString());
            BigDecimal b1 = new BigDecimal(divisor.toString());
            BigDecimal result = b0.remainder(b1);
            if (dividend instanceof BigDecimal || divisor instanceof BigDecimal) {
                return result;
            }
            return MathUtils.coerceToWidestFloatingType(dividend, divisor, result.doubleValue());
        }
    }
}

