/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.Optional;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.lang3.tuple.Pair;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableExpandCollationOnProjectExprRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.util.OpenSearchRelOptUtil;

@Value.Enclosing
public class ExpandCollationOnProjectExprRule
extends RelRule<Config> {
    protected ExpandCollationOnProjectExprRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        AbstractConverter converter = (AbstractConverter)call.rel(0);
        Project project = (Project)call.rel(1);
        RelTraitSet toTraits = converter.getTraitSet();
        RelCollation toCollation = (RelCollation)toTraits.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        RelTrait fromTrait = project.getInput().getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if (fromTrait != null && fromTrait instanceof RelCollation) {
            RelCollation fromCollation = (RelCollation)fromTrait;
            if (toCollation == null || toCollation.getFieldCollations().isEmpty() || fromCollation == null || fromCollation.getFieldCollations().size() < toCollation.getFieldCollations().size()) {
                return;
            }
            for (int i = 0; i < toCollation.getFieldCollations().size(); ++i) {
                RelFieldCollation.Direction equivalentSourceDirection;
                RelFieldCollation targetFieldCollation = (RelFieldCollation)toCollation.getFieldCollations().get(i);
                Optional<Pair<Integer, Boolean>> equivalentCollationInputInfo = OpenSearchRelOptUtil.getOrderEquivalentInputInfo((RexNode)project.getProjects().get(targetFieldCollation.getFieldIndex()));
                if (equivalentCollationInputInfo.isEmpty()) {
                    return;
                }
                RelFieldCollation sourceFieldCollation = (RelFieldCollation)fromCollation.getFieldCollations().get(i);
                int equivalentSourceIndex = (Integer)equivalentCollationInputInfo.get().getLeft();
                RelFieldCollation.Direction direction = equivalentSourceDirection = (Boolean)equivalentCollationInputInfo.get().getRight() != false ? targetFieldCollation.getDirection().reverse() : targetFieldCollation.getDirection();
                if (equivalentSourceIndex == sourceFieldCollation.getFieldIndex() && equivalentSourceDirection == sourceFieldCollation.getDirection()) continue;
                return;
            }
            Project newProject = project.copy(toTraits, project.getInput(), project.getProjects(), project.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableExpandCollationOnProjectExprRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(AbstractConverter.class).oneInput(b1 -> b1.operand(EnumerableProject.class).predicate(OpenSearchIndexScanRule::projectContainsExpr).predicate(p -> !p.containsOver()).anyInputs()));

        default public ExpandCollationOnProjectExprRule toRule() {
            return new ExpandCollationOnProjectExprRule(this);
        }
    }
}

