/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchProjectIndexScanRule;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchProjectIndexScanRule
extends RelRule<Config> {
    protected OpenSearchProjectIndexScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length != 2) {
            throw new AssertionError((Object)String.format("The length of rels should be %s but got %s", this.operands.size(), call.rels.length));
        }
        LogicalProject project = (LogicalProject)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        this.apply(call, project, scan);
    }

    protected void apply(RelOptRuleCall call, LogicalProject project, CalciteLogicalIndexScan scan) {
        RelOptTable table = scan.getTable();
        Objects.requireNonNull((OpenSearchIndex)table.unwrap(OpenSearchIndex.class));
        final SelectedColumns selectedColumns = new SelectedColumns();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(this, true){

            public Void visitInputRef(RexInputRef inputRef) {
                if (!selectedColumns.contains(inputRef.getIndex())) {
                    selectedColumns.add(inputRef.getIndex());
                }
                return null;
            }
        };
        visitor.visitEach((Iterable)project.getProjects());
        if (!selectedColumns.isEmpty() && !selectedColumns.isIdentity(scan.getRowType().getFieldCount())) {
            Mapping mapping = Mappings.target((List)selectedColumns, (int)scan.getRowType().getFieldCount());
            CalciteLogicalIndexScan newScan = scan.pushDownProject(selectedColumns);
            if (newScan != null) {
                List newProjectRexNodes = RexUtil.apply((Mappings.TargetMapping)mapping, (Iterable)project.getProjects());
                if (RexUtil.isIdentity((List)newProjectRexNodes, (RelDataType)newScan.getRowType())) {
                    call.transformTo((RelNode)newScan);
                } else {
                    call.transformTo(call.builder().push((RelNode)newScan).project((Iterable)newProjectRexNodes).build());
                }
            }
        }
    }

    static final class SelectedColumns
    extends ArrayList<Integer> {
        private boolean isSequential = true;
        private Integer current = 0;

        SelectedColumns() {
        }

        @Override
        public boolean add(Integer integer) {
            if (this.isSequential) {
                Integer n = this.current;
                this.current = this.current + 1;
                if (!Objects.equals(integer, n)) {
                    this.isSequential = false;
                }
            }
            return super.add(integer);
        }

        public boolean isIdentity(Integer size) {
            return this.isSequential && size.intValue() == this.size();
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchProjectIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).noInputs()));

        default public OpenSearchProjectIndexScanRule toRule() {
            return new OpenSearchProjectIndexScanRule(this);
        }
    }
}

