/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.ArraySourceValueFetcher;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.knn.index.KNNVectorIndexFieldData;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MemoryOptimizedSearchSupportSpec;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.VectorTransformerFactory;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class KNNVectorFieldType
extends MappedFieldType {
    private static final Logger logger = LogManager.getLogger(KNNVectorFieldType.class);
    KNNMappingConfig knnMappingConfig;
    VectorDataType vectorDataType;
    boolean memoryOptimizedSearchAvailable;
    Version indexCreatedVersion;

    public KNNVectorFieldType(String name, Map<String, String> metadata, VectorDataType vectorDataType, KNNMappingConfig annConfig, Version indexCreatedVersion) {
        this(name, metadata, vectorDataType, annConfig);
        this.memoryOptimizedSearchAvailable = MemoryOptimizedSearchSupportSpec.isSupportedFieldType(this.knnMappingConfig.getKnnMethodContext(), annConfig.getQuantizationConfig(), annConfig.getModelId());
        this.indexCreatedVersion = indexCreatedVersion;
    }

    public KNNVectorFieldType(String name, Map<String, String> metadata, VectorDataType vectorDataType, KNNMappingConfig annConfig) {
        super(name, false, false, true, TextSearchInfo.NONE, metadata);
        this.vectorDataType = vectorDataType;
        this.knnMappingConfig = annConfig;
    }

    public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        return new ArraySourceValueFetcher(this, this.name(), context){

            protected Object parseSourceValue(Object value) {
                if (value instanceof ArrayList) {
                    return value;
                }
                logger.warn("Expected type ArrayList for value, but got {} ", value.getClass());
                return Collections.emptyList();
            }
        };
    }

    public String typeName() {
        return "knn_vector";
    }

    public Query existsQuery(QueryShardContext context) {
        return new FieldExistsQuery(this.name());
    }

    public Query termQuery(Object value, QueryShardContext context) {
        throw new QueryShardException(context, String.format(Locale.ROOT, "KNN vector do not support exact searching, use KNN queries instead: [%s]", this.name()), new Object[0]);
    }

    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        this.failIfNoDocValues();
        return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES, this.vectorDataType);
    }

    public Object valueForDisplay(Object value) {
        return KNNVectorFieldMapperUtil.deserializeStoredVector((BytesRef)value, this.vectorDataType);
    }

    public RescoreContext resolveRescoreContext(RescoreContext userProvidedContext) {
        if (userProvidedContext != null) {
            return userProvidedContext;
        }
        KNNMappingConfig knnMappingConfig = this.getKnnMappingConfig();
        int dimension = knnMappingConfig.getDimension();
        CompressionLevel compressionLevel = knnMappingConfig.getCompressionLevel();
        Mode mode = knnMappingConfig.getMode();
        return compressionLevel.getDefaultRescoreContext(mode, dimension, knnMappingConfig.getIndexCreatedVersion());
    }

    public void transformQueryVector(float[] vector) {
        if (VectorDataType.FLOAT != this.vectorDataType) {
            return;
        }
        Optional<KNNMethodContext> knnMethodContext = this.knnMappingConfig.getKnnMethodContext();
        if (knnMethodContext.isPresent()) {
            KNNMethodContext context = knnMethodContext.get();
            VectorTransformerFactory.getVectorTransformer(context.getKnnEngine(), context.getSpaceType()).transform(vector);
            return;
        }
        Optional<String> modelId = this.knnMappingConfig.getModelId();
        if (modelId.isPresent()) {
            ModelDao.OpenSearchKNNModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();
            ModelMetadata metadata = modelDao.getMetadata(modelId.get());
            VectorTransformerFactory.getVectorTransformer(metadata.getKnnEngine(), metadata.getSpaceType()).transform(vector);
            return;
        }
        throw new IllegalStateException("Either KNN method context or Model Id should be configured");
    }

    @Generated
    public KNNMappingConfig getKnnMappingConfig() {
        return this.knnMappingConfig;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    @Generated
    public boolean isMemoryOptimizedSearchAvailable() {
        return this.memoryOptimizedSearchAvailable;
    }

    @Generated
    public Version getIndexCreatedVersion() {
        return this.indexCreatedVersion;
    }
}

