@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
for %%i in ("%~dp0..") do set "BASEDIR=%%~fi"

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\org\apache\groovy\groovy\4.0.29\groovy-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-ant\4.0.29\groovy-ant-4.0.29.jar;"%REPO%"\org\apache\ant\ant\1.10.15\ant-1.10.15.jar;"%REPO%"\org\apache\ant\ant-junit\1.10.15\ant-junit-1.10.15.jar;"%REPO%"\org\apache\ant\ant-launcher\1.10.15\ant-launcher-1.10.15.jar;"%REPO%"\org\apache\ant\ant-antlr\1.10.15\ant-antlr-1.10.15.jar;"%REPO%"\org\apache\groovy\groovy-cli-picocli\4.0.29\groovy-cli-picocli-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-console\4.0.29\groovy-console-4.0.29.jar;"%REPO%"\com\github\javaparser\javaparser-core\3.27.1\javaparser-core-3.27.1.jar;"%REPO%"\org\ow2\asm\asm-util\9.9\asm-util-9.9.jar;"%REPO%"\org\ow2\asm\asm\9.9\asm-9.9.jar;"%REPO%"\org\ow2\asm\asm-tree\9.9\asm-tree-9.9.jar;"%REPO%"\org\ow2\asm\asm-analysis\9.9\asm-analysis-9.9.jar;"%REPO%"\org\apache\ivy\ivy\2.5.3\ivy-2.5.3.jar;"%REPO%"\org\abego\treelayout\org.abego.treelayout.core\1.0.3\org.abego.treelayout.core-1.0.3.jar;"%REPO%"\org\apache\groovy\groovy-datetime\4.0.29\groovy-datetime-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-docgenerator\4.0.29\groovy-docgenerator-4.0.29.jar;"%REPO%"\com\thoughtworks\qdox\qdox\1.12.1\qdox-1.12.1.jar;"%REPO%"\org\apache\groovy\groovy-groovydoc\4.0.29\groovy-groovydoc-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-groovysh\4.0.29\groovy-groovysh-4.0.29.jar;"%REPO%"\jline\jline\2.14.6\jline-2.14.6.jar;"%REPO%"\org\apache\groovy\groovy-jmx\4.0.29\groovy-jmx-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-json\4.0.29\groovy-json-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-jsr223\4.0.29\groovy-jsr223-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-macro\4.0.29\groovy-macro-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-nio\4.0.29\groovy-nio-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-servlet\4.0.29\groovy-servlet-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-sql\4.0.29\groovy-sql-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-swing\4.0.29\groovy-swing-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-templates\4.0.29\groovy-templates-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-test\4.0.29\groovy-test-4.0.29.jar;"%REPO%"\junit\junit\4.13.2\junit-4.13.2.jar;"%REPO%"\org\hamcrest\hamcrest-core\1.3\hamcrest-core-1.3.jar;"%REPO%"\org\apache\groovy\groovy-test-junit5\4.0.29\groovy-test-junit5-4.0.29.jar;"%REPO%"\org\junit\jupiter\junit-jupiter-api\5.13.3\junit-jupiter-api-5.13.3.jar;"%REPO%"\org\opentest4j\opentest4j\1.3.0\opentest4j-1.3.0.jar;"%REPO%"\org\junit\platform\junit-platform-launcher\1.13.3\junit-platform-launcher-1.13.3.jar;"%REPO%"\org\junit\platform\junit-platform-engine\1.13.3\junit-platform-engine-1.13.3.jar;"%REPO%"\org\junit\platform\junit-platform-commons\1.13.3\junit-platform-commons-1.13.3.jar;"%REPO%"\org\junit\jupiter\junit-jupiter-engine\5.14.2\junit-jupiter-engine-5.14.2.jar;"%REPO%"\org\apache\groovy\groovy-xml\4.0.29\groovy-xml-4.0.29.jar;"%REPO%"\org\apache\groovy\groovy-yaml\4.0.29\groovy-yaml-4.0.29.jar;"%REPO%"\com\fasterxml\jackson\dataformat\jackson-dataformat-yaml\2.20.1\jackson-dataformat-yaml-2.20.1.jar;"%REPO%"\org\yaml\snakeyaml\2.5\snakeyaml-2.5.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-core\2.20.1\jackson-core-2.20.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-databind\2.20.1\jackson-databind-2.20.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-annotations\2.20\jackson-annotations-2.20.jar;"%REPO%"\info\picocli\picocli\4.7.7\picocli-4.7.7.jar;"%REPO%"\com\squareup\okhttp3\okhttp-jvm\5.3.2\okhttp-jvm-5.3.2.jar;"%REPO%"\com\squareup\okio\okio-jvm\3.16.4\okio-jvm-3.16.4.jar;"%REPO%"\org\jetbrains\kotlin\kotlin-stdlib\2.2.21\kotlin-stdlib-2.2.21.jar;"%REPO%"\org\jetbrains\annotations\13.0\annotations-13.0.jar;"%REPO%"\org\apache\commons\commons-csv\1.14.1\commons-csv-1.14.1.jar;"%REPO%"\commons-io\commons-io\2.21.0\commons-io-2.21.0.jar;"%REPO%"\commons-codec\commons-codec\1.20.0\commons-codec-1.20.0.jar;"%REPO%"\org\craftercms\cli\4.5.0\cli-4.5.0.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS%  -classpath %CLASSPATH% -Dapp.name="crafter-cli" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" org.craftercms.cli.Main %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
