/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.ResultWriteRequest;

public class ResultBulkRequest<ResultType extends IndexableResult, ResultWriteRequestType extends ResultWriteRequest<ResultType>>
extends ActionRequest
implements Writeable {
    private final List<ResultWriteRequestType> results;

    public ResultBulkRequest() {
        this.results = new ArrayList<ResultWriteRequestType>();
    }

    public ResultBulkRequest(StreamInput in, Writeable.Reader<ResultWriteRequestType> reader) throws IOException {
        super(in);
        int size = in.readVInt();
        this.results = new ArrayList<ResultWriteRequestType>(size);
        for (int i = 0; i < size; ++i) {
            this.results.add((ResultWriteRequest)reader.read(in));
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.results.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no requests added", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.results.size());
        for (ResultWriteRequest result : this.results) {
            result.writeTo(out);
        }
    }

    public List<ResultWriteRequestType> getResults() {
        return this.results;
    }

    public void add(ResultWriteRequestType resultWriteRequest) {
        this.results.add(resultWriteRequest);
    }

    public int numberOfActions() {
        return this.results.size();
    }
}

