/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.search.batch.AbstractUpdateDetailProvider;

@JsonIgnoreProperties(value={"updateDetails", "updateLog"})
public class ChangeSet
extends AbstractUpdateDetailProvider {
    protected List<String> createdFiles;
    protected List<String> updatedFiles;
    protected List<String> deletedFiles;

    public ChangeSet() {
        this.createdFiles = new ArrayList();
        this.updatedFiles = new ArrayList();
        this.deletedFiles = new ArrayList();
    }

    public ChangeSet(List<String> createdFiles, List<String> updatedFiles, List<String> deletedFiles) {
        this.createdFiles = createdFiles;
        this.updatedFiles = updatedFiles;
        this.deletedFiles = deletedFiles;
    }

    @JsonProperty(value="created_files")
    public List<String> getCreatedFiles() {
        return this.createdFiles;
    }

    public void addCreatedFile(String file) {
        if (!this.createdFiles.contains(file)) {
            this.createdFiles.add(file);
        }
    }

    public void removeCreatedFile(String file) {
        this.createdFiles.remove(file);
    }

    @JsonProperty(value="updated_files")
    public List<String> getUpdatedFiles() {
        return this.updatedFiles;
    }

    public void addUpdatedFile(String file) {
        if (!this.updatedFiles.contains(file)) {
            this.updatedFiles.add(file);
        }
    }

    public void removeUpdatedFile(String file) {
        this.updatedFiles.remove(file);
    }

    @JsonProperty(value="deleted_files")
    public List<String> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void addDeletedFile(String file) {
        if (!this.deletedFiles.contains(file)) {
            this.deletedFiles.add(file);
        }
    }

    public void removeDeletedFile(String file) {
        this.deletedFiles.remove(file);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty((Collection)this.createdFiles) && CollectionUtils.isEmpty((Collection)this.updatedFiles) && CollectionUtils.isEmpty((Collection)this.deletedFiles);
    }
}

