/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import org.craftercms.deployer.api.Deployment;

public class ProcessorExecution {
    protected String processorName;
    protected volatile ZonedDateTime start;
    protected volatile ZonedDateTime end;
    protected volatile Deployment.Status status;
    protected volatile Object statusDetails;

    public ProcessorExecution(String processorName) {
        this.processorName = processorName;
        this.start = ZonedDateTime.now();
    }

    @JsonProperty(value="processor_name")
    public String getProcessorName() {
        return this.processorName;
    }

    @JsonProperty(value="start")
    public ZonedDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public ZonedDateTime getEnd() {
        return this.end;
    }

    @JsonProperty(value="running")
    public boolean isRunning() {
        return this.end == null;
    }

    @JsonProperty(value="status")
    public Deployment.Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status_details")
    public Object getStatusDetails() {
        return this.statusDetails;
    }

    public void setStatusDetails(Object statusDetails) {
        this.statusDetails = statusDetails;
    }

    public void endExecution(Deployment.Status status) {
        if (this.isRunning()) {
            this.end = ZonedDateTime.now();
            this.status = status;
        }
    }
}

