/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.DeploymentPipeline;
import org.craftercms.deployer.api.DeploymentProcessor;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.DeploymentPipelineFactory;
import org.craftercms.deployer.impl.DeploymentPipelineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="deploymentPipelineFactory")
public class DeploymentPipelineFactoryImpl
implements DeploymentPipelineFactory {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentPipelineFactoryImpl.class);

    public DeploymentPipeline getPipeline(HierarchicalConfiguration<ImmutableNode> configuration, ApplicationContext applicationContext, String pipelinePropertyName) throws ConfigurationException, DeployerException {
        List processorConfigs = ConfigUtils.getRequiredConfigurationsAt(configuration, (String)pipelinePropertyName);
        ArrayList<DeploymentProcessor> deploymentProcessors = new ArrayList<DeploymentProcessor>();
        for (HierarchicalConfiguration processorConfig : processorConfigs) {
            String processorName = ConfigUtils.getRequiredStringProperty((Configuration)processorConfig, (String)"processorName");
            logger.debug("Initializing pipeline processor '{}'", (Object)processorName);
            try {
                DeploymentProcessor processor = (DeploymentProcessor)applicationContext.getBean(processorName, DeploymentProcessor.class);
                processor.init((Configuration)processorConfig);
                deploymentProcessors.add(processor);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new DeployerException("No processor bean found with name '" + processorName + "'", (Throwable)e);
            }
            catch (Exception e) {
                throw new DeployerException("Failed to initialize pipeline processor '" + processorName + "'", (Throwable)e);
            }
        }
        boolean postProcessorFound = false;
        for (DeploymentProcessor processor : deploymentProcessors) {
            if (!processor.isPostDeployment() && postProcessorFound) {
                throw new DeployerException("Processor " + String.valueOf(processor) + " can't be defined after a post processor has already being defined");
            }
            if (!processor.isPostDeployment()) continue;
            postProcessorFound = true;
        }
        return new DeploymentPipelineImpl(deploymentProcessors);
    }
}

