/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.craftercms.deployer.impl.ProcessorStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorStateStoreImpl
implements ProcessorStateStore {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorStateStoreImpl.class);
    private File storeFolder;

    public String load(String targetId, String processorName, String suffix) throws IOException {
        File lastDateFile = this.getLastDateFile(targetId, processorName, suffix);
        if (!lastDateFile.exists()) {
            logger.info("State file does not exist '{}'", (Object)lastDateFile);
            return null;
        }
        return FileUtils.readFileToString((File)lastDateFile, (String)"UTF-8").trim();
    }

    public void store(String targetId, String processorName, String suffix, String value) throws IOException {
        FileUtils.write((File)this.getLastDateFile(targetId, processorName, suffix), (CharSequence)value, (String)"UTF-8", (boolean)false);
    }

    public void delete(String targetId) {
        File targetNotificationsFolder = new File(this.storeFolder, targetId);
        if (targetNotificationsFolder.exists()) {
            logger.info("Deleting processor state files directory for target '{}'", (Object)targetId);
            FileUtils.deleteQuietly((File)targetNotificationsFolder);
        }
    }

    private File getLastDateFile(String targetId, String processorName, String suffix) {
        String filename = "%s/%s-%s".formatted(targetId, processorName, suffix);
        return new File(this.storeFolder, filename);
    }

    public void setStoreFolder(File storeFolder) {
        this.storeFolder = storeFolder;
    }
}

