/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.EncryptionAwareConfigurationReader;
import org.craftercms.commons.spring.ApacheCommonsConfiguration2PropertySource;
import org.craftercms.commons.upgrade.UpgradeManager;
import org.craftercms.commons.validation.ValidationException;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.exceptions.TargetAlreadyExistsException;
import org.craftercms.deployer.api.exceptions.TargetNotFoundException;
import org.craftercms.deployer.api.exceptions.TargetServiceException;
import org.craftercms.deployer.impl.DeploymentPipelineFactory;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.ProcessorStateStore;
import org.craftercms.deployer.impl.TargetImpl;
import org.craftercms.deployer.impl.TargetLifecycleHooksResolver;
import org.craftercms.deployer.impl.TargetServiceImpl;
import org.craftercms.deployer.utils.handlebars.MissingValueHelper;
import org.craftercms.search.opensearch.OpenSearchAdminService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;

@Component(value="targetService")
@DependsOn(value={"crafter.cacheStoreAdapter"})
public class TargetServiceImpl
implements TargetService,
ApplicationListener<ApplicationReadyEvent>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TargetServiceImpl.class);
    public static final String YAML_FILE_EXTENSION = "yaml";
    public static final String APPLICATION_CONTEXT_FILENAME_FORMAT = "%s-context.xml";
    public static final String CONFIG_PROPERTY_SOURCE_NAME = "targetConfig";
    public static final String CONFIG_BEAN_NAME = "targetConfig";
    public static final String TARGET_ENV_MODEL_KEY = "env";
    public static final String TARGET_SITE_NAME_MODEL_KEY = "site_name";
    public static final String TARGET_SOURCE_TARGET_MODEL_KEY = "source_target";
    public static final String TARGET_ID_MODEL_KEY = "target_id";
    protected final File targetConfigFolder;
    protected final Resource baseTargetYamlConfigResource;
    protected final Resource baseTargetYamlConfigOverrideResource;
    protected final Resource baseTargetContextResource;
    protected final Resource baseTargetContextOverrideResource;
    protected final String defaultTargetConfigTemplateName;
    protected final Handlebars targetConfigTemplateEngine;
    protected final ApplicationContext mainApplicationContext;
    protected final DeploymentPipelineFactory deploymentPipelineFactory;
    protected final TaskScheduler taskScheduler;
    protected final ExecutorService taskExecutor;
    protected final ProcessedCommitsStore processedCommitsStore;
    protected final ProcessorStateStore processorStateStore;
    protected final TargetLifecycleHooksResolver targetLifecycleHooksResolver;
    protected final EncryptionAwareConfigurationReader configurationReader;
    protected final UpgradeManager<Target> upgradeManager;
    protected final Set<Target> currentTargets;
    protected final int maxTargetInitRetryAttempts;

    public TargetServiceImpl(@Value(value="${deployer.main.targets.config.folderPath}") File targetConfigFolder, @Value(value="${deployer.main.targets.config.baseYaml.location}") Resource baseTargetYamlConfigResource, @Value(value="${deployer.main.targets.config.baseYaml.overrideLocation}") Resource baseTargetYamlConfigOverrideResource, @Value(value="${deployer.main.targets.config.baseContext.location}") Resource baseTargetContextResource, @Value(value="${deployer.main.targets.config.baseContext.overrideLocation}") Resource baseTargetContextOverrideResource, @Value(value="${deployer.main.targets.config.templates.default}") String defaultTargetConfigTemplateName, @Value(value="${deployer.main.targets.maxInitRetries}") int maxTargetInitRetryAttempts, @Autowired Handlebars targetConfigTemplateEngine, @Autowired ApplicationContext mainApplicationContext, @Autowired DeploymentPipelineFactory deploymentPipelineFactory, @Autowired TaskScheduler taskScheduler, @Autowired ExecutorService taskExecutor, @Autowired ProcessedCommitsStore processedCommitsStore, @Autowired ProcessorStateStore processorStateStore, @Autowired TargetLifecycleHooksResolver targetLifecycleHooksResolver, @Autowired EncryptionAwareConfigurationReader configurationReader, @Autowired UpgradeManager<Target> upgradeManager) {
        this.targetConfigFolder = targetConfigFolder;
        this.baseTargetYamlConfigResource = baseTargetYamlConfigResource;
        this.baseTargetYamlConfigOverrideResource = baseTargetYamlConfigOverrideResource;
        this.baseTargetContextResource = baseTargetContextResource;
        this.baseTargetContextOverrideResource = baseTargetContextOverrideResource;
        this.defaultTargetConfigTemplateName = defaultTargetConfigTemplateName;
        this.targetConfigTemplateEngine = targetConfigTemplateEngine;
        this.mainApplicationContext = mainApplicationContext;
        this.deploymentPipelineFactory = deploymentPipelineFactory;
        this.taskScheduler = taskScheduler;
        this.taskExecutor = taskExecutor;
        this.processedCommitsStore = processedCommitsStore;
        this.processorStateStore = processorStateStore;
        this.targetLifecycleHooksResolver = targetLifecycleHooksResolver;
        this.configurationReader = configurationReader;
        this.upgradeManager = upgradeManager;
        this.currentTargets = new CopyOnWriteArraySet();
        this.maxTargetInitRetryAttempts = maxTargetInitRetryAttempts;
    }

    public void afterPropertiesSet() throws DeployerException {
        if (this.targetConfigFolder.exists()) {
            return;
        }
        logger.info("Target config folder '{}' doesn't exist. Creating it", (Object)this.targetConfigFolder);
        try {
            FileUtils.forceMkdir((File)this.targetConfigFolder);
        }
        catch (IOException e) {
            throw new DeployerException(String.format("Failed to create target config folder at '%s'", this.targetConfigFolder));
        }
    }

    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        try {
            List targets = this.resolveTargets();
            if (CollectionUtils.isEmpty((Collection)targets)) {
                logger.warn("No config files found under '{}'", (Object)this.targetConfigFolder.getAbsolutePath());
            } else {
                targets.forEach(Target::unlock);
            }
        }
        catch (DeployerException e) {
            logger.error("Error while loading targets on startup", (Throwable)e);
        }
    }

    public void destroy() {
        logger.info("Closing all targets...");
        if (CollectionUtils.isNotEmpty((Collection)this.currentTargets)) {
            this.currentTargets.forEach(Target::close);
        }
    }

    public List<Target> getAllTargets() {
        return new ArrayList<Target>(this.currentTargets);
    }

    public boolean targetExists(String env, String siteName) {
        String id = TargetImpl.getId((String)env, (String)siteName);
        return this.findLoadedTargetById(id) != null;
    }

    public Target getTarget(String env, String siteName) throws TargetNotFoundException {
        String id = TargetImpl.getId((String)env, (String)siteName);
        Target target = this.findLoadedTargetById(id);
        if (target != null) {
            return target;
        }
        throw new TargetNotFoundException(id, env, siteName);
    }

    public synchronized List<Target> resolveTargets() throws TargetServiceException {
        Collection configFiles = this.getTargetConfigFiles();
        ArrayList<Target> targets = new ArrayList<Target>();
        if (!CollectionUtils.isNotEmpty((Collection)configFiles)) {
            return targets;
        }
        this.closeTargetsWithNoConfigFile(configFiles);
        for (File file : configFiles) {
            Target target = this.resolveTargetFromConfigFile(file, LoadMode.LOAD);
            targets.add(target);
        }
        return targets;
    }

    public synchronized Target createTarget(String env, String siteName, boolean replace, String templateName, Map<String, Object> templateParams) throws TargetAlreadyExistsException, TargetServiceException {
        String id = TargetImpl.getId((String)env, (String)siteName);
        File configFile = new File(this.targetConfigFolder, id + ".yaml");
        if (!replace && configFile.exists()) {
            throw new TargetAlreadyExistsException(id, env, siteName);
        }
        this.createConfigFromTemplate(env, siteName, id, templateName, templateParams, configFile);
        return this.resolveTargetFromConfigFile(configFile, LoadMode.CREATE);
    }

    public synchronized void deleteTarget(String env, String siteName) throws TargetNotFoundException, TargetServiceException {
        Target target = this.getTarget(env, siteName);
        String id = target.getId();
        logger.info("Removing loaded target '{}'", (Object)id);
        this.currentTargets.remove(target);
        target.delete();
        this.cleanupTarget(id, target.getConfigurationFile());
    }

    private void cleanupTarget(String targetId, File configFile) throws TargetServiceException {
        File contextFile;
        try {
            this.processedCommitsStore.delete(targetId);
        }
        catch (DeployerException e) {
            throw new TargetServiceException(String.format("Error while deleting processed commit from store for target '%s'", targetId), (Throwable)e);
        }
        if (configFile.exists()) {
            logger.info("Deleting target configuration file at '{}'", (Object)configFile);
            FileUtils.deleteQuietly((File)configFile);
        }
        if ((contextFile = new File(this.targetConfigFolder, String.format(APPLICATION_CONTEXT_FILENAME_FORMAT, configFile.getName()))).exists()) {
            logger.info("Deleting target context file at '{}'", (Object)contextFile);
            FileUtils.deleteQuietly((File)contextFile);
        }
        this.processorStateStore.delete(targetId);
    }

    public void recreateIndex(String env, String siteName) throws TargetNotFoundException, ConfigurationException {
        Target target = this.getTarget(env, siteName);
        ConfigurableApplicationContext appContext = target.getApplicationContext();
        OpenSearchAdminService adminService = (OpenSearchAdminService)appContext.getBean(OpenSearchAdminService.class);
        String indexIdFormat = ConfigUtils.getRequiredStringProperty((Configuration)target.getConfiguration(), (String)"target.search.indexIdFormat");
        String indexName = String.format(indexIdFormat, siteName);
        adminService.recreateIndex(indexName);
    }

    public synchronized void duplicateTarget(String env, String sourceSiteName, String siteName, boolean replace, String templateName, Map<String, Object> templateParams) throws TargetNotFoundException, TargetAlreadyExistsException, TargetServiceException {
        if (!replace && this.targetExists(env, siteName)) {
            throw new TargetAlreadyExistsException(siteName, env, siteName);
        }
        Target srcTarget = this.getTarget(env, sourceSiteName);
        templateParams.put(TARGET_SOURCE_TARGET_MODEL_KEY, srcTarget);
        String id = TargetImpl.getId((String)env, (String)siteName);
        File configFile = new File(this.targetConfigFolder, id + ".yaml");
        if (!replace && configFile.exists()) {
            throw new TargetAlreadyExistsException(id, env, siteName);
        }
        this.createConfigFromTemplate(env, siteName, id, templateName, templateParams, configFile);
        this.resolveTargetFromConfigFile(configFile, LoadMode.DUPLICATE);
    }

    protected Collection<File> getTargetConfigFiles() throws TargetServiceException {
        if (this.targetConfigFolder.exists()) {
            return FileUtils.listFiles((File)this.targetConfigFolder, (IOFileFilter)new CustomConfigFileFilter(this), null);
        }
        logger.warn("Config folder '{}' doesn't exist. Trying to create it...", (Object)this.targetConfigFolder.getAbsolutePath());
        try {
            FileUtils.forceMkdir((File)this.targetConfigFolder);
        }
        catch (IOException e) {
            throw new TargetServiceException(String.format("Unable to create config folder '%s'", this.targetConfigFolder), (Throwable)e);
        }
        return Collections.emptyList();
    }

    protected void closeTargetsWithNoConfigFile(Collection<File> configFiles) {
        if (!CollectionUtils.isNotEmpty((Collection)this.currentTargets)) {
            return;
        }
        this.currentTargets.removeIf(target -> {
            File configFile = target.getConfigurationFile();
            if (configFiles.contains(configFile)) {
                return false;
            }
            logger.info("Config file '{}' doesn't exist anymore for target '{}'. Closing target...", (Object)configFile, (Object)target.getId());
            target.close();
            return true;
        });
    }

    protected Target resolveTargetFromConfigFile(File configFile, LoadMode loadMode) throws TargetServiceException {
        int targetInitRetryAttempts;
        String baseName = FilenameUtils.getBaseName((String)configFile.getName());
        File contextFile = new File(this.targetConfigFolder, String.format(APPLICATION_CONTEXT_FILENAME_FORMAT, baseName));
        Target target = this.findLoadedTargetByConfigFile(configFile);
        if (target != null) {
            long yamlLastModified = configFile.exists() ? configFile.lastModified() : 0L;
            long contextLastModified = contextFile.exists() ? contextFile.lastModified() : 0L;
            long targetLoadedDate = target.getLoadDate().toInstant().toEpochMilli();
            targetInitRetryAttempts = target.getInitRetryAttempts();
            if (yamlLastModified >= targetLoadedDate || contextLastModified >= targetLoadedDate) {
                logger.info("Configuration files haven been updated for '{}'. The target will be reloaded.", (Object)target.getId());
                target.close();
                this.currentTargets.remove(target);
                target = null;
            } else if (target.getStatus() == Target.Status.INIT_FAILED) {
                if (targetInitRetryAttempts > 0) {
                    logger.info("Target '{}' is in INIT_FAILED state. Reloading target. {} attempts left", (Object)target.getId(), (Object)targetInitRetryAttempts);
                    target.close();
                    this.currentTargets.remove(target);
                    target = null;
                } else {
                    logger.error("Target '{}' is in INIT_FAILED state and has no retry attempts left. Not reloading target.", (Object)target.getId());
                }
            }
        } else {
            targetInitRetryAttempts = this.maxTargetInitRetryAttempts;
            logger.info("No loaded target found for configuration file {}", (Object)configFile);
        }
        if (target == null) {
            logger.info("Loading target for configuration file {}", (Object)configFile);
            target = this.loadTarget(configFile, contextFile, loadMode, targetInitRetryAttempts);
            this.currentTargets.add(target);
        }
        return target;
    }

    protected TargetImpl buildTarget(File configFile, File contextFile) throws Exception {
        HierarchicalConfiguration config = this.loadConfiguration(configFile);
        String env = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)"target.env");
        String siteName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)"target.siteName");
        String targetId = TargetImpl.getId((String)env, (String)siteName);
        config.setProperty("target.id", (Object)targetId);
        config.setProperty("target.configFile", (Object)configFile.toString());
        ConfigurableApplicationContext context = this.loadApplicationContext(config, contextFile);
        return (TargetImpl)context.getBean(TargetImpl.class);
    }

    protected Target loadTarget(File configFile, File contextFile, LoadMode loadMode, int retryAttempts) throws TargetServiceException {
        try {
            TargetImpl target = this.buildTarget(configFile, contextFile);
            this.upgradeManager.upgrade((Object)target);
            target.close();
            target = this.buildTarget(configFile, contextFile);
            switch (loadMode.ordinal()) {
                case 1: {
                    target.executeCreateHooks();
                    break;
                }
                case 2: {
                    target.executeDuplicateHooks();
                }
            }
            target.setInitRetryAttempts(retryAttempts);
            this.startInit((Target)target);
            return target;
        }
        catch (Exception e) {
            if (loadMode.isCreate()) {
                FileUtils.deleteQuietly((File)configFile);
            }
            throw new TargetServiceException(String.format("Failed to load target for configuration file '%s'", configFile), (Throwable)e);
        }
    }

    protected HierarchicalConfiguration loadConfiguration(File configFile) throws ConfigurationException {
        String configFilename = configFile.getPath();
        logger.debug("Loading target YAML config at {}", (Object)configFilename);
        HierarchicalConfiguration config = this.configurationReader.readYamlConfiguration(configFile);
        if (!this.baseTargetYamlConfigResource.exists() && !this.baseTargetYamlConfigOverrideResource.exists()) {
            return config;
        }
        CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        combinedConfig.addConfiguration((Configuration)config);
        combinedConfig.setPrefixLookups(config.getInterpolator().getLookups());
        if (this.baseTargetYamlConfigOverrideResource.exists()) {
            logger.debug("Loading base target YAML config override at {}", (Object)this.baseTargetYamlConfigOverrideResource);
            combinedConfig.addConfiguration((Configuration)this.configurationReader.readYamlConfiguration(this.baseTargetYamlConfigOverrideResource));
        }
        if (this.baseTargetYamlConfigResource.exists()) {
            logger.debug("Loading base target YAML config at {}", (Object)this.baseTargetYamlConfigResource);
            combinedConfig.addConfiguration((Configuration)this.configurationReader.readYamlConfiguration(this.baseTargetYamlConfigResource));
        }
        return combinedConfig;
    }

    protected ConfigurableApplicationContext loadApplicationContext(HierarchicalConfiguration config, File contextFile) throws ConfigurationException {
        GenericApplicationContext context = new GenericApplicationContext(this.mainApplicationContext);
        MutablePropertySources propertySources = context.getEnvironment().getPropertySources();
        propertySources.addFirst((PropertySource)new ApacheCommonsConfiguration2PropertySource("targetConfig", (Configuration)config));
        context.getBeanFactory().registerSingleton("targetConfig", (Object)config);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        reader.setValidationMode(3);
        if (this.baseTargetContextResource.exists()) {
            logger.debug("Loading base target application context at {}", (Object)this.baseTargetContextResource);
            try {
                reader.loadBeanDefinitions(this.baseTargetContextResource);
            }
            catch (Exception e) {
                throw new ConfigurationException(String.format("Failed to load application context at '%s'", this.baseTargetContextResource), (Throwable)e);
            }
        }
        if (this.baseTargetContextOverrideResource.exists()) {
            logger.debug("Loading base target application context override at {}", (Object)this.baseTargetContextOverrideResource);
            try {
                reader.loadBeanDefinitions(this.baseTargetContextOverrideResource);
            }
            catch (Exception e) {
                throw new ConfigurationException(String.format("Failed to load application context at '%s'", this.baseTargetContextOverrideResource), (Throwable)e);
            }
        }
        if (contextFile.exists()) {
            logger.debug("Loading target application context at '{}'", (Object)contextFile);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(contextFile));){
                reader.loadBeanDefinitions(new InputSource(in));
            }
            catch (Exception e) {
                throw new ConfigurationException(String.format("Failed to load application context at '%s'", contextFile), (Throwable)e);
            }
        }
        context.refresh();
        return context;
    }

    protected void createConfigFromTemplate(String env, String siteName, String targetId, String templateName, Map<String, Object> templateParameters, File configFile) throws TargetServiceException {
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            templateName = this.defaultTargetConfigTemplateName;
        }
        HashMap<String, Object> templateModel = new HashMap<String, Object>();
        templateModel.put(TARGET_ENV_MODEL_KEY, env);
        templateModel.put(TARGET_SITE_NAME_MODEL_KEY, siteName);
        templateModel.put(TARGET_ID_MODEL_KEY, targetId);
        if (MapUtils.isNotEmpty(templateParameters)) {
            templateModel.putAll(templateParameters);
        }
        logger.info("Creating new target YAML configuration at {} using template '{}'", (Object)configFile, (Object)templateName);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(configFile));){
            this.processConfigTemplate(templateName, templateModel, (Writer)out);
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new TargetServiceException(String.format("Unable to open writer to YAML configuration file '%s'", configFile), (Throwable)e);
        }
        catch (TargetServiceException e) {
            FileUtils.deleteQuietly((File)configFile);
            throw e;
        }
    }

    protected void processConfigTemplate(String templateName, Object templateModel, Writer out) throws TargetServiceException {
        MissingValueHelper helper = MissingValueHelper.INSTANCE;
        try {
            Template template = this.targetConfigTemplateEngine.compile(templateName);
            template.apply(templateModel, out);
        }
        catch (IOException e) {
            throw new TargetServiceException(String.format("Processing of configuration template '%s' failed", templateName), (Throwable)e);
        }
        ValidationResult result = helper.getValidationResult();
        helper.clearValidationResult();
        if (result != null && result.hasErrors()) {
            throw new TargetServiceException((Throwable)new ValidationException(result));
        }
    }

    protected Target findLoadedTargetByConfigFile(File configFile) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)this.currentTargets)) {
            return null;
        }
        return this.currentTargets.stream().filter(target -> target.getConfigurationFile().equals(configFile)).findFirst().orElse(null);
    }

    protected Target findLoadedTargetById(String id) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)this.currentTargets)) {
            return null;
        }
        return this.currentTargets.stream().filter(target -> target.getId().equals(id)).findFirst().orElse(null);
    }

    protected void startInit(Target target) {
        this.taskExecutor.execute(() -> ((Target)target).init());
    }
}

