/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.events;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.events.DeploymentEventsStore;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.springframework.beans.factory.InitializingBean;

public class FileBasedDeploymentEventsStore
implements DeploymentEventsStore<Properties, Path>,
InitializingBean {
    protected String folderPath;
    protected String filePattern;

    public FileBasedDeploymentEventsStore(String folderPath, String filePattern) {
        this.folderPath = folderPath;
        this.filePattern = filePattern;
    }

    public void afterPropertiesSet() throws Exception {
        Files.createDirectories(Paths.get(this.folderPath, new String[0]), new FileAttribute[0]);
    }

    protected Path getPath(Target target) {
        return Paths.get(this.folderPath, String.format(this.filePattern, target.getId()));
    }

    public Properties loadDeploymentEvents(Target target) throws DeployerException {
        Properties deploymentEvents = new Properties();
        Path deploymentEventsPath = this.getPath(target);
        if (Files.exists(deploymentEventsPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(deploymentEventsPath, StandardCharsets.UTF_8);){
                deploymentEvents.load(reader);
            }
            catch (IOException e) {
                throw new DeployerException("Error reading loading events file @ " + String.valueOf(deploymentEventsPath), (Throwable)e);
            }
        }
        return deploymentEvents;
    }

    public void saveDeploymentEvents(Target target, Properties deploymentEvents) throws DeployerException {
        Path deploymentEventsPath = this.getPath(target);
        try (BufferedWriter writer = Files.newBufferedWriter(deploymentEventsPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            deploymentEvents.store(writer, null);
        }
        catch (IOException e) {
            throw new DeployerException("Error saving deployment events file @ " + String.valueOf(deploymentEventsPath), (Throwable)e);
        }
    }

    public Path getSource(Target target) {
        return this.getPath(target);
    }
}

