/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import java.beans.ConstructorProperties;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.search.opensearch.OpenSearchAdminService;

public abstract class AbstractIndexAwareLifecycleHook
extends AbstractLifecycleHook {
    protected static final String INDEX_ID_CONFIG_KEY = "indexId";
    protected final String siteName;
    protected final String indexIdFormat;
    protected final OpenSearchAdminService searchAdminService;
    protected String indexId;

    @ConstructorProperties(value={"siteName", "indexIdFormat", "searchAdminService"})
    public AbstractIndexAwareLifecycleHook(String siteName, String indexIdFormat, OpenSearchAdminService searchAdminService) {
        this.siteName = siteName;
        this.indexIdFormat = indexIdFormat;
        this.searchAdminService = searchAdminService;
    }

    public void doInit(Configuration config) throws ConfigurationException {
        this.indexId = ConfigUtils.getStringProperty((Configuration)config, (String)INDEX_ID_CONFIG_KEY);
        if (StringUtils.isEmpty((CharSequence)this.indexId)) {
            this.indexId = String.format(this.indexIdFormat, this.siteName);
        }
    }
}

