/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.lifecycle.TargetLifecycleHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifecycleHook
implements TargetLifecycleHook {
    public static final String CONFIG_KEY_DISABLED = "disabled";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean disabled;

    public void init(Configuration config) throws ConfigurationException, DeployerException {
        this.disabled = config.getBoolean(CONFIG_KEY_DISABLED, false);
        this.doInit(config);
    }

    protected abstract void doInit(Configuration var1) throws ConfigurationException, DeployerException;

    public void execute(Target target) throws DeployerException {
        if (this.disabled) {
            this.logger.info("Skipping execution for target {}", (Object)target.getId());
        } else {
            this.doExecute(target);
        }
    }

    protected abstract void doExecute(Target var1) throws DeployerException;
}

