/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import java.beans.ConstructorProperties;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractIndexAwareLifecycleHook;
import org.craftercms.search.commons.exception.SearchException;
import org.craftercms.search.opensearch.OpenSearchAdminService;

public class CreateIndexLifecycleHook
extends AbstractIndexAwareLifecycleHook {
    @ConstructorProperties(value={"siteName", "indexIdFormat", "searchAdminService"})
    public CreateIndexLifecycleHook(String siteName, String indexIdFormat, OpenSearchAdminService searchAdminService) {
        super(siteName, indexIdFormat, searchAdminService);
    }

    public void doExecute(Target target) throws DeployerException {
        try {
            this.logger.info("Creating OpenSearch index for target '{}'", (Object)target.getId());
            this.searchAdminService.createIndex(this.indexId);
        }
        catch (SearchException e) {
            throw new DeployerException("Error creating index for target '" + target.getId() + "'", (Throwable)e);
        }
    }
}

