/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle;

import java.beans.ConstructorProperties;
import org.apache.commons.lang.StringUtils;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractIndexAwareLifecycleHook;
import org.craftercms.search.opensearch.OpenSearchAdminService;

public class DuplicateIndexHook
extends AbstractIndexAwareLifecycleHook {
    private final String sourceSiteName;

    @ConstructorProperties(value={"siteName", "indexIdFormat", "searchAdminService", "sourceSiteName"})
    public DuplicateIndexHook(String siteName, String indexIdFormat, OpenSearchAdminService searchAdminService, String sourceSiteName) {
        super(siteName, indexIdFormat, searchAdminService);
        this.sourceSiteName = sourceSiteName;
    }

    protected void doExecute(Target target) throws DeployerException {
        if (StringUtils.isEmpty((String)this.sourceSiteName)) {
            throw new DeployerException("'target.sourceSiteName' is required for target duplication");
        }
        String sourceIndexIdFormat = target.getConfiguration().getString("target.search.indexIdFormat");
        String sourceIndexId = String.format(sourceIndexIdFormat, this.sourceSiteName);
        this.logger.info("Starting index duplicate from '{}' for site '{}' to '{}' for site '{}'", new Object[]{sourceIndexId, this.sourceSiteName, this.indexId, this.siteName});
        this.searchAdminService.duplicateIndex(sourceIndexId, this.indexId);
        this.logger.info("Completed index duplicate from '{}' for site '{}' to '{}' for site '{}'", new Object[]{sourceIndexId, this.sourceSiteName, this.indexId, this.siteName});
    }
}

