/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.lifecycle.aws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.lifecycle.AbstractLifecycleHook;
import org.craftercms.deployer.utils.aws.AwsClientBuilderConfigurer;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

public class ClearS3BucketLifecycleHook
extends AbstractLifecycleHook {
    protected static final String CONFIG_KEY_BUCKET_NAME = "bucketName";
    protected AwsClientBuilderConfigurer builderConfigurer;
    protected String bucketName;

    public void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsClientBuilderConfigurer(config);
        this.bucketName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_BUCKET_NAME);
    }

    public void doExecute(Target target) throws DeployerException {
        try {
            S3Client s3 = this.buildClient();
            if (!this.bucketExist(s3, this.bucketName)) {
                return;
            }
            this.logger.info("Emptying bucket '{}'...", (Object)this.bucketName);
            this.deleteAllObjects(s3);
            this.deleteAllVersionsAndMarkers(s3);
        }
        catch (Exception e) {
            throw new DeployerException("Error while trying to clear S3 bucket '" + this.bucketName + "'", (Throwable)e);
        }
    }

    protected S3Client buildClient() {
        S3ClientBuilder builder = S3Client.builder();
        this.builderConfigurer.configureClientBuilder((AwsClientBuilder)builder);
        return (S3Client)builder.build();
    }

    private boolean bucketExist(S3Client s3Client, String bucketName) {
        try {
            HeadBucketRequest request = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
            HeadBucketResponse response = s3Client.headBucket(request);
            return response.sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchBucketException e) {
            this.logger.debug("Error while get head of bucket '{}", (Object)bucketName, (Object)e);
            return false;
        }
    }

    private void deleteAllObjects(S3Client s3) {
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).build();
        ListObjectsV2Iterable listObjectsV2Responses = s3.listObjectsV2Paginator(request);
        for (ListObjectsV2Response objectList : listObjectsV2Responses) {
            List objectsToDelete = objectList.contents().stream().map(s -> (ObjectIdentifier)ObjectIdentifier.builder().key(s.key()).build()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(objectsToDelete)) {
                this.logger.info("Deleting {} objects", (Object)objectsToDelete.size());
                s3.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucketName).delete((Delete)Delete.builder().objects(objectsToDelete).build()).build());
                continue;
            }
            this.logger.info("No objects to delete");
        }
    }

    private void deleteAllVersionsAndMarkers(S3Client s3) {
        ListObjectVersionsRequest listObjectVersionsRequest = (ListObjectVersionsRequest)ListObjectVersionsRequest.builder().bucket(this.bucketName).build();
        ListObjectVersionsIterable listObjectVersionsResponses = s3.listObjectVersionsPaginator(listObjectVersionsRequest);
        for (ListObjectVersionsResponse versionList : listObjectVersionsResponses) {
            ArrayList versionsToDelete = new ArrayList();
            versionList.versions().forEach(v -> versionsToDelete.add((ObjectIdentifier)ObjectIdentifier.builder().key(v.key()).versionId(v.versionId()).build()));
            versionList.deleteMarkers().forEach(m -> versionsToDelete.add((ObjectIdentifier)ObjectIdentifier.builder().key(m.key()).versionId(m.versionId()).build()));
            if (CollectionUtils.isNotEmpty(versionsToDelete)) {
                this.logger.info("Deleting {} object versions and delete markers", (Object)versionsToDelete.size());
                for (List subList : ListUtils.partition(versionsToDelete, (int)1000)) {
                    DeleteObjectsResponse result = s3.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucketName).delete((Delete)Delete.builder().objects((Collection)subList).build()).build());
                    this.logger.debug("Deleted object versions and delete markers: {}", (Object)result.deleted());
                }
                continue;
            }
            this.logger.info("No object versions to delete");
        }
    }
}

