/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import org.apache.commons.configuration2.Configuration;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DelayProcessor.class);
    protected static final String CONFIG_KEY_SECONDS = "seconds";
    protected long seconds;

    protected void doInit(Configuration config) {
        this.seconds = config.getLong(CONFIG_KEY_SECONDS, 10L);
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) {
        logger.info("Delaying pipeline execution for {} seconds", (Object)this.seconds);
        try {
            Thread.sleep(this.seconds * 1000L);
        }
        catch (InterruptedException e) {
            logger.warn("Could not delay pipeline execution", (Throwable)e);
        }
        return null;
    }

    protected void doDestroy() throws DeployerException {
    }
}

