/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors;

import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.beans.ConstructorProperties;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ScriptProcessor
extends AbstractMainDeploymentProcessor
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ScriptProcessor.class);
    public static final String CONFIG_KEY_SCRIPT_PATH = "scriptPath";
    public static final String SCRIPT_VAR_LOGGER = "logger";
    public static final String SCRIPT_VAR_APP_CTX = "applicationContext";
    public static final String SCRIPT_VAR_DEPLOYMENT = "deployment";
    public static final String SCRIPT_VAR_EXECUTION = "execution";
    public static final String SCRIPT_VAR_FILTERED_CHANGE_SET = "filteredChangeSet";
    public static final String SCRIPT_VAR_ORIGINAL_CHANGE_SET = "originalChangeSet";
    protected ApplicationContext applicationContext;
    protected final GroovyScriptEngine scriptEngine;
    protected final SandboxInterceptor sandboxInterceptor;
    protected String scriptPath;

    @ConstructorProperties(value={"scriptEngine", "sandboxInterceptor"})
    public ScriptProcessor(GroovyScriptEngine scriptEngine, SandboxInterceptor sandboxInterceptor) {
        this.scriptEngine = scriptEngine;
        this.sandboxInterceptor = sandboxInterceptor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        this.scriptPath = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_SCRIPT_PATH);
    }

    protected void doDestroy() {
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        if (this.sandboxInterceptor != null) {
            this.sandboxInterceptor.register();
        }
        try {
            Binding binding = new Binding();
            binding.setVariable(SCRIPT_VAR_LOGGER, (Object)logger);
            binding.setVariable(SCRIPT_VAR_APP_CTX, (Object)this.applicationContext);
            binding.setVariable(SCRIPT_VAR_DEPLOYMENT, (Object)deployment);
            binding.setVariable(SCRIPT_VAR_EXECUTION, (Object)execution);
            binding.setVariable(SCRIPT_VAR_FILTERED_CHANGE_SET, (Object)filteredChangeSet);
            binding.setVariable(SCRIPT_VAR_ORIGINAL_CHANGE_SET, (Object)originalChangeSet);
            logger.info("Starting execution of script {}", (Object)this.scriptPath);
            Object result = this.scriptEngine.run(this.scriptPath, binding);
            logger.info("Completed execution of script {}", (Object)this.scriptPath);
            if (result != null && !ChangeSet.class.isAssignableFrom(result.getClass())) {
                throw new DeployerException("Incompatible type " + result.getClass().getName() + " returned by script " + this.scriptPath);
            }
            ChangeSet changeSet = (ChangeSet)result;
            return changeSet;
        }
        catch (Throwable e) {
            throw new DeployerException("Error executing script " + this.scriptPath, e);
        }
        finally {
            if (this.sandboxInterceptor != null) {
                this.sandboxInterceptor.unregister();
            }
        }
    }
}

