/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.aws;

import java.net.URI;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.aws.AwsUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.craftercms.deployer.utils.aws.AwsS3ClientBuilderConfigurer;
import org.craftercms.deployer.utils.aws.AwsS3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Uri;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public abstract class AbstractS3Processor
extends AbstractMainDeploymentProcessor {
    protected static final String CONFIG_KEY_URL = "url";
    protected static final String DELIMITER = "/";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AwsS3ClientBuilderConfigurer builderConfigurer;
    protected S3Uri s3Url;
    protected ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public AbstractS3Processor(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        this.builderConfigurer = new AwsS3ClientBuilderConfigurer(config);
        String uri = HttpUtils.encodeUrlMacro((String)StringUtils.appendIfMissing((String)ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_URL), (CharSequence)DELIMITER, (CharSequence[])new CharSequence[0]));
        this.s3Url = this.buildClient().utilities().parseUri(URI.create(uri));
        this.failDeploymentOnFailure = config.getBoolean("failDeploymentOnFailure", true);
    }

    protected String getS3BaseKey() {
        return AwsS3Utils.getS3BaseKey((S3Uri)this.s3Url, (String)this.siteName);
    }

    protected String getBucket() {
        return AwsS3Utils.getBucket((S3Uri)this.s3Url, (String)this.siteName);
    }

    protected String getS3Key(String file) {
        String path = StringUtils.appendIfMissing((String)this.getS3BaseKey(), (CharSequence)DELIMITER, (CharSequence[])new CharSequence[0]) + StringUtils.stripStart((String)file, (String)DELIMITER);
        return StringUtils.stripStart((String)path, (String)DELIMITER);
    }

    protected S3Client buildClient() {
        S3ClientBuilder builder = S3Client.builder();
        this.builderConfigurer.configureClientBuilder((S3BaseClientBuilder)builder);
        return (S3Client)builder.build();
    }

    protected S3AsyncClient buildAsyncClient() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        this.builderConfigurer.configureClientBuilder((S3BaseClientBuilder)builder);
        return (S3AsyncClient)builder.build();
    }

    protected S3TransferManager buildTransferManager(S3AsyncClient client) {
        return AwsUtils.buildTransferManager((S3AsyncClient)client);
    }

    protected void doDestroy() throws DeployerException {
    }
}

