/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.aws;

import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.events.DeploymentEventsStore;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.aws.AbstractS3Processor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3DeploymentEventsProcessor
extends AbstractS3Processor {
    protected static final String DEFAULT_DEPLOYMENT_EVENTS_FILE_URL = "deployment-events.properties";
    protected static final String CONFIG_KEY_DEPLOYMENT_EVENTS_FILE_URL = "deploymentEventsFileUrl";
    protected DeploymentEventsStore<?, Path> store;
    protected String deploymentEventsFileUrl;

    @ConstructorProperties(value={"threadPoolTaskExecutor", "store"})
    public S3DeploymentEventsProcessor(ThreadPoolTaskExecutor threadPoolTaskExecutor, DeploymentEventsStore<?, Path> store) {
        super(threadPoolTaskExecutor);
        this.store = store;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        super.doInit(config);
        this.deploymentEventsFileUrl = ConfigUtils.getStringProperty((Configuration)config, (String)CONFIG_KEY_DEPLOYMENT_EVENTS_FILE_URL, (String)DEFAULT_DEPLOYMENT_EVENTS_FILE_URL);
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        S3Client client = this.buildClient();
        Path file = (Path)this.store.getSource(deployment.getTarget());
        if (Files.exists(file, new LinkOption[0])) {
            this.logger.info("Uploading deployment events from {}", (Object)file);
            try {
                PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).key(this.getS3Key(this.deploymentEventsFileUrl)).build();
                client.putObject(request, RequestBody.fromFile((File)file.toFile()));
            }
            catch (Exception e) {
                throw new DeployerException("Error uploading deployment events @ " + String.valueOf(file), (Throwable)e);
            }
        } else {
            this.logger.debug("No events found for target {}", (Object)this.targetId);
        }
        return null;
    }
}

