/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.aws;

import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.aws.AbstractS3Processor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;

public class S3SyncProcessor
extends AbstractS3Processor {
    public static final String CONFIG_KEY_IGNORE_BLOBS = "ignoreBlobs";
    protected String localRepoUrl;
    protected String blobExtension;
    protected boolean ignoreBlobs;

    @ConstructorProperties(value={"threadPoolTaskExecutor", "localRepoUrl", "blobExtension"})
    public S3SyncProcessor(ThreadPoolTaskExecutor threadPoolTaskExecutor, String localRepoUrl, String blobExtension) {
        super(threadPoolTaskExecutor);
        this.localRepoUrl = localRepoUrl;
        this.blobExtension = blobExtension;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        super.doInit(config);
        this.ignoreBlobs = ConfigUtils.getBooleanProperty((Configuration)config, (String)CONFIG_KEY_IGNORE_BLOBS, (Boolean)true);
    }

    protected boolean shouldIncludeFile(String file) {
        return super.shouldIncludeFile(file) && (!this.ignoreBlobs || !StringUtils.endsWith((CharSequence)file, (CharSequence)this.blobExtension));
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        this.logger.info("Performing S3 sync with bucket {}...", (Object)this.s3Url);
        try {
            S3AsyncClient asyncClient = this.buildAsyncClient();
            List changedFiles = ListUtils.union((List)filteredChangeSet.getCreatedFiles(), (List)filteredChangeSet.getUpdatedFiles());
            if (CollectionUtils.isNotEmpty((Collection)changedFiles)) {
                this.uploadFiles(asyncClient, changedFiles);
            }
            S3Client client = this.buildClient();
            if (CollectionUtils.isNotEmpty((Collection)filteredChangeSet.getDeletedFiles())) {
                this.deleteFiles(client, filteredChangeSet.getDeletedFiles());
            }
        }
        catch (S3Exception e) {
            throw new DeployerException("Error connecting to S3", (Throwable)e);
        }
        return null;
    }

    protected void uploadFiles(S3AsyncClient client, List<String> paths) throws DeployerException {
        this.logger.info("Uploading {} files", (Object)paths.size());
        S3TransferManager transferManager = this.buildTransferManager(client);
        try {
            List<CompletableFuture> futures = paths.stream().map(item -> {
                Path path = Paths.get(this.localRepoUrl, item);
                if (path.toFile().exists()) {
                    UploadFileRequest uploadFileRequest = (UploadFileRequest)UploadFileRequest.builder().putObjectRequest(p -> p.bucket(this.getBucket()).key(this.getS3Key(item))).source(path).build();
                    return ((CompletableFuture)CompletableFuture.runAsync(() -> transferManager.uploadFile(uploadFileRequest).completionFuture().join(), (Executor)this.threadPoolTaskExecutor).thenRun(() -> this.logger.debug("Uploaded file: {}", item))).exceptionally(e -> {
                        this.logger.error("Error uploading file: {}", item, e);
                        return null;
                    });
                }
                if (Paths.get(this.localRepoUrl, item + this.blobExtension).toFile().exists()) {
                    this.logger.debug("Blob-backed file found, no file to upload: {}", item);
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.failedFuture(new FileNotFoundException(String.format("File '%s' not found", item)));
            }).toList();
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            this.logger.debug("Uploads completed");
        }
        catch (Exception e) {
            throw new DeployerException(String.format("Error uploading files '%s'", paths), (Throwable)e);
        }
    }

    protected void deleteFiles(S3Client client, List<String> files) throws DeployerException {
        if (CollectionUtils.isNotEmpty(files)) {
            this.logger.info("Deleting {} files", (Object)files.size());
            this.logger.debug("Deleting files: {}", files);
            List keys = files.stream().map(arg_0 -> ((S3SyncProcessor)this).getS3Key(arg_0)).collect(Collectors.toList());
            try {
                for (List subList : ListUtils.partition(keys, (int)1000)) {
                    List identifiers = subList.stream().map(s -> (ObjectIdentifier)ObjectIdentifier.builder().key(s).build()).collect(Collectors.toList());
                    DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.getBucket()).delete((Delete)Delete.builder().objects(identifiers).build()).build();
                    DeleteObjectsResponse result = client.deleteObjects(request);
                    this.logger.debug("Deleted files: {}", (Object)result.deleted());
                }
            }
            catch (Exception e) {
                throw new DeployerException("Error deleting files", (Throwable)e);
            }
        }
    }
}

