/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.git;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.git.utils.GitUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.craftercms.deployer.impl.processors.git.GitDiffProcessor;
import org.craftercms.search.batch.UpdateDetail;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitDiffProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GitDiffProcessor.class);
    protected static final String INCLUDE_GIT_LOG_CONFIG_KEY = "includeGitLog";
    public static final String UPDATE_COMMIT_CONFIG_KEY = "updateCommitStore";
    protected File localRepoFolder;
    protected ProcessedCommitsStore processedCommitsStore;
    protected boolean includeGitLog;
    protected String blobFileExtension;
    protected boolean updateCommitStore;

    public void setLocalRepoFolder(File localRepoFolder) {
        this.localRepoFolder = localRepoFolder;
    }

    public void setProcessedCommitsStore(ProcessedCommitsStore processedCommitsStore) {
        this.processedCommitsStore = processedCommitsStore;
    }

    public void setBlobFileExtension(String blobFileExtension) {
        this.blobFileExtension = blobFileExtension;
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        this.includeGitLog = ConfigUtils.getBooleanProperty((Configuration)config, (String)INCLUDE_GIT_LOG_CONFIG_KEY, (Boolean)false);
        this.updateCommitStore = ConfigUtils.getBooleanProperty((Configuration)config, (String)UPDATE_COMMIT_CONFIG_KEY, (Boolean)true);
        this.failDeploymentOnFailure = config.getBoolean("failDeploymentOnFailure", true);
    }

    protected void doDestroy() throws DeployerException {
    }

    public boolean supportsMode(Deployment.Mode mode) {
        return mode == Deployment.Mode.PUBLISH || mode == Deployment.Mode.SEARCH_INDEX;
    }

    protected boolean shouldExecute(Deployment deployment, ChangeSet filteredChangeSet) {
        return deployment.isRunning();
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        boolean regularPublish = deployment.getMode() == Deployment.Mode.PUBLISH;
        ObjectId fromCommitId = this.getFromCommitIdParam(deployment);
        boolean reprocessAllFiles = this.getReprocessAllFilesParam(deployment);
        if (fromCommitId == null && reprocessAllFiles) {
            if (regularPublish) {
                this.processedCommitsStore.delete(this.targetId);
            }
            logger.info("All files from local repo {} will be reprocessed", (Object)this.localRepoFolder);
        }
        try (Git git = this.openLocalRepository();){
            ObjectId latestCommitId;
            ChangeSet changeSet;
            ObjectId previousCommitId = null;
            if (fromCommitId == null) {
                if (!reprocessAllFiles) {
                    previousCommitId = this.processedCommitsStore.load(this.targetId);
                }
            } else {
                previousCommitId = fromCommitId;
            }
            if ((changeSet = this.resolveChangeSetFromCommits(git, previousCommitId, latestCommitId = this.getLatestCommitId(git))) != null) {
                if (this.includeGitLog) {
                    this.updateChangeDetails(changeSet, git, previousCommitId, latestCommitId);
                }
                execution.setStatusDetails((Object)"Changes detected and resolved successfully");
            } else {
                execution.setStatusDetails((Object)"No changes detected");
            }
            deployment.addParam("latest_commit_id", (Object)latestCommitId);
            if (this.updateCommitStore && regularPublish) {
                this.processedCommitsStore.store(this.targetId, latestCommitId);
            }
            ChangeSet changeSet2 = changeSet;
            return changeSet2;
        }
    }

    protected void updateChangeDetails(ChangeSet changeSet, Git git, ObjectId previousCommitId, ObjectId latestCommitId) {
        HashMap<String, UpdateDetail> changeDetails = new HashMap<String, UpdateDetail>();
        HashMap changeLog = new HashMap();
        try {
            LogCommand logCmd = git.log();
            if (previousCommitId != null && latestCommitId != null) {
                logCmd.addRange((AnyObjectId)git.getRepository().parseCommit((AnyObjectId)previousCommitId), (AnyObjectId)git.getRepository().parseCommit((AnyObjectId)latestCommitId));
            }
            Iterable log = logCmd.call();
            for (RevCommit commit : log) {
                UpdateDetail detail = new UpdateDetail();
                detail.setAuthor(commit.getAuthorIdent().getName());
                detail.setDate(Instant.ofEpochSecond(commit.getCommitTime()));
                changeDetails.put(commit.getName(), detail);
                ObjectReader reader = git.getRepository().newObjectReader();
                try {
                    RevCommit parent = commit.getParentCount() > 0 ? commit.getParent(0) : null;
                    List diff = GitUtils.doDiff((Git)git, (ObjectReader)reader, (ObjectId)parent, (ObjectId)commit);
                    diff.forEach(entry -> {
                        if (entry.getChangeType() != DiffEntry.ChangeType.DELETE) {
                            changeLog.putIfAbsent(StringUtils.removeEnd((String)entry.getNewPath(), (String)this.blobFileExtension), commit.getName());
                        }
                    });
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            changeSet.setUpdateDetails(changeDetails);
            changeSet.setUpdateLog(changeLog);
        }
        catch (Exception e) {
            logger.error("Error getting git log for commits {} {}", new Object[]{previousCommitId, latestCommitId, e});
        }
    }

    protected Git openLocalRepository() throws DeployerException {
        try {
            logger.debug("Opening local Git repository at {}", (Object)this.localRepoFolder);
            return GitUtils.openRepository((File)this.localRepoFolder);
        }
        catch (IOException e) {
            throw new DeployerException("Failed to open Git repository at " + String.valueOf(this.localRepoFolder), (Throwable)e);
        }
    }

    protected ObjectId getLatestCommitId(Git git) throws DeployerException {
        try {
            return git.getRepository().resolve("HEAD");
        }
        catch (IOException e) {
            throw new DeployerException("Unable to retrieve HEAD commit ID", (Throwable)e);
        }
    }

    protected ChangeSet resolveChangeSetFromCommits(Git git, ObjectId fromCommitId, ObjectId toCommitId) throws DeployerException {
        String toCommitIdStr;
        String fromCommitIdStr = fromCommitId != null ? fromCommitId.name() : "{empty}";
        String string = toCommitIdStr = toCommitId != null ? toCommitId.name() : "{empty}";
        if (!Objects.equals(fromCommitId, toCommitId)) {
            ChangeSet changeSet;
            block9: {
                logger.info("Calculating change set from commits: {} -> {}", (Object)fromCommitIdStr, (Object)toCommitIdStr);
                ObjectReader reader = git.getRepository().newObjectReader();
                try {
                    changeSet = this.processDiffEntries(GitUtils.doDiff((Git)git, (ObjectReader)reader, (ObjectId)fromCommitId, (ObjectId)toCommitId));
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | GitAPIException e) {
                        throw new DeployerException("Failed to calculate change set from commits: " + fromCommitIdStr + " -> " + toCommitIdStr, e);
                    }
                }
                reader.close();
            }
            return changeSet;
        }
        logger.info("Commits are the same. No change set will be calculated");
        return null;
    }

    protected ChangeSet processDiffEntries(List<DiffEntry> diffEntries) {
        ArrayList<String> createdFiles = new ArrayList<String>();
        ArrayList<String> updatedFiles = new ArrayList<String>();
        ArrayList<String> deletedFiles = new ArrayList<String>();
        block6: for (DiffEntry entry : diffEntries) {
            String newPath;
            switch (1.$SwitchMap$org$eclipse$jgit$diff$DiffEntry$ChangeType[entry.getChangeType().ordinal()]) {
                case 1: {
                    newPath = this.asContentStoreUrl(entry.getNewPath());
                    updatedFiles.add(newPath);
                    logger.debug("Updated file: {}", (Object)newPath);
                    continue block6;
                }
                case 2: {
                    String oldPath = this.asContentStoreUrl(entry.getOldPath());
                    deletedFiles.add(oldPath);
                    logger.debug("Deleted file: {}", (Object)oldPath);
                    continue block6;
                }
                case 3: {
                    String oldPath = this.asContentStoreUrl(entry.getOldPath());
                    newPath = this.asContentStoreUrl(entry.getNewPath());
                    deletedFiles.add(oldPath);
                    createdFiles.add(newPath);
                    logger.debug("Renamed file: {} -> {}", (Object)oldPath, (Object)newPath);
                    continue block6;
                }
                case 4: {
                    String oldPath = this.asContentStoreUrl(entry.getOldPath());
                    newPath = this.asContentStoreUrl(entry.getNewPath());
                    createdFiles.add(newPath);
                    logger.debug("Copied file: {} -> {}", (Object)oldPath, (Object)newPath);
                    continue block6;
                }
            }
            newPath = this.asContentStoreUrl(entry.getNewPath());
            createdFiles.add(newPath);
            logger.debug("New file: {}", (Object)newPath);
        }
        return new ChangeSet(createdFiles, updatedFiles, deletedFiles);
    }

    protected String asContentStoreUrl(String path) {
        return StringUtils.removeEnd((String)StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]), (String)this.blobFileExtension);
    }

    protected boolean getReprocessAllFilesParam(Deployment deployment) {
        Object value = deployment.getParam("reprocess_all_files");
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return BooleanUtils.toBoolean((String)value.toString());
        }
        return false;
    }

    protected ObjectId getFromCommitIdParam(Deployment deployment) {
        ObjectId objectId = null;
        Object value = deployment.getParam("from_commit_id");
        if (value != null) {
            objectId = ObjectId.fromString((String)((String)value));
        }
        return objectId;
    }
}

