/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.git;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.craftercms.commons.git.utils.AuthConfiguratorFactory;
import org.craftercms.commons.git.utils.GitUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.git.AbstractRemoteGitRepoAwareProcessor;
import org.craftercms.deployer.impl.processors.git.GitPullProcessor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPullProcessor
extends AbstractRemoteGitRepoAwareProcessor {
    protected static final String REMOTE_REPO_NAME_CONFIG_KEY = "remoteRepo.name";
    protected static final String MERGE_STRATEGY_CONFIG_KEY = "mergeStrategy";
    protected static final String CONTENT_MERGE_STRATEGY_OPTION_CONFIG_KEY = "contentMergeOption";
    protected static final String FAST_FORWARD_MODE_CONFIG_KEY = "fastForwardMode";
    private static final Logger logger = LoggerFactory.getLogger(GitPullProcessor.class);
    protected String remoteRepoName;
    protected MergeStrategy mergeStrategy;
    protected ContentMergeStrategy contentMergeStrategy;
    protected MergeCommand.FastForwardMode fastForwardMode;

    public GitPullProcessor(File localRepoFolder, AuthConfiguratorFactory authConfiguratorFactory) {
        super(localRepoFolder, authConfiguratorFactory);
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        super.doInit(config);
        this.remoteRepoName = ConfigUtils.getStringProperty((Configuration)config, (String)REMOTE_REPO_NAME_CONFIG_KEY, (String)"origin");
        this.mergeStrategy = (MergeStrategy)this.throwIfNull(config, MERGE_STRATEGY_CONFIG_KEY, MergeStrategy.THEIRS.getName(), MergeStrategy::get);
        this.contentMergeStrategy = (ContentMergeStrategy)this.throwIfNull(config, CONTENT_MERGE_STRATEGY_OPTION_CONFIG_KEY, ContentMergeStrategy.CONFLICT.name(), ContentMergeStrategy::valueOf);
        this.fastForwardMode = (MergeCommand.FastForwardMode)this.throwIfNull(config, FAST_FORWARD_MODE_CONFIG_KEY, MergeCommand.FastForwardMode.FF.name(), MergeCommand.FastForwardMode::valueOf);
        this.failDeploymentOnFailure = config.getBoolean("failDeploymentOnFailure", true);
    }

    private <T> T throwIfNull(Configuration config, String configKey, String defaultValue, Function<String, T> mappingFunction) throws ConfigurationException {
        String rawValue = ConfigUtils.getStringProperty((Configuration)config, (String)configKey, (String)defaultValue);
        T value = mappingFunction.apply(rawValue);
        if (Objects.isNull(value)) {
            throw new ConfigurationException("Unsupported value '%s' for configuration key '%s'".formatted(rawValue, configKey));
        }
        return value;
    }

    protected boolean failDeploymentOnProcessorFailure() {
        return true;
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        File gitFolder = new File(this.localRepoFolder, ".git");
        if (this.localRepoFolder.exists() && gitFolder.exists()) {
            this.doPull(execution);
        } else {
            this.doClone(execution);
        }
        return null;
    }

    protected void doPull(ProcessorExecution execution) throws DeployerException {
        try (Git git = this.openLocalRepository();){
            logger.info("Executing git pull for repository {}...", (Object)this.localRepoFolder);
            GitUtils.discardAllChanges((Git)git);
            PullResult pullResult = GitUtils.pull((Git)git, (String)this.remoteRepoName, (String)this.remoteRepoUrl, (String)this.remoteRepoBranch, (MergeStrategy)this.mergeStrategy, (ContentMergeStrategy)this.contentMergeStrategy, (MergeCommand.FastForwardMode)this.fastForwardMode, (GitAuthenticationConfigurator)this.authenticationConfigurator);
            String details = pullResult != null && pullResult.getMergeResult() != null ? this.checkMergeResult(pullResult.getMergeResult()) : "No pull or merge result returned after pull operation";
            logger.info(details);
            execution.setStatusDetails((Object)details);
        }
        catch (JGitInternalException e) {
            if (this.isRepositoryCorrupted((Throwable)e)) {
                logger.warn("The local repository {} is corrupt, trying to fix it", (Object)this.localRepoFolder);
                try {
                    GitUtils.deleteGitIndex((String)this.localRepoFolder.getAbsolutePath());
                    logger.info(".git/index is deleted from local repository '{}'", (Object)this.localRepoFolder);
                }
                catch (IOException ioe) {
                    throw new DeployerException("Error deleting index for local repo " + String.valueOf(this.localRepoFolder), (Throwable)ioe);
                }
            }
            logger.error("Unknown internal git error in local repository {}", (Object)this.localRepoFolder, (Object)e);
            throw e;
        }
        catch (URISyntaxException | GitAPIException e) {
            throw new DeployerException("Execution of git pull failed:", e);
        }
    }

    protected String checkMergeResult(MergeResult mergeResult) throws DeployerException {
        MergeResult.MergeStatus status = mergeResult.getMergeStatus();
        if (status.isSuccessful()) {
            switch (1.$SwitchMap$org$eclipse$jgit$api$MergeResult$MergeStatus[status.ordinal()]) {
                case 1: 
                case 2: {
                    return "Changes successfully pulled from remote repo " + this.remoteRepoUrl + " into local repo " + String.valueOf(this.localRepoFolder) + " (merge result with status " + String.valueOf(status) + ")";
                }
                case 3: {
                    return "Local repository " + String.valueOf(this.localRepoFolder) + " up to date (no changes pulled from remote repo " + this.remoteRepoUrl + ") (merge result with status " + String.valueOf(status) + ")";
                }
            }
            throw new DeployerException("Received unexpected merge result after executing pull: " + String.valueOf(status));
        }
        throw new DeployerException("Merge failed with status " + String.valueOf(status));
    }

    protected void doClone(ProcessorExecution execution) throws DeployerException {
        try (Git git = this.cloneRemoteRepository();){
            String details = "Successfully cloned Git remote repository " + this.remoteRepoUrl + " into " + String.valueOf(this.localRepoFolder);
            logger.info(details);
            execution.setStatusDetails((Object)details);
        }
    }

    protected Git cloneRemoteRepository() throws DeployerException {
        try {
            if (this.localRepoFolder.exists()) {
                logger.debug("Deleting existing folder {} before cloning", (Object)this.localRepoFolder);
                FileUtils.forceDelete((File)this.localRepoFolder);
            } else {
                logger.debug("Creating folder {} and any nonexistent parents before cloning", (Object)this.localRepoFolder);
                FileUtils.forceMkdir((File)this.localRepoFolder);
            }
            logger.info("Cloning Git remote repository {} into {}", (Object)this.remoteRepoUrl, (Object)this.localRepoFolder);
            return GitUtils.cloneRemoteRepository((String)this.remoteRepoName, (String)this.remoteRepoUrl, (String)this.remoteRepoBranch, (GitAuthenticationConfigurator)this.authenticationConfigurator, (File)this.localRepoFolder, null, null, null);
        }
        catch (IOException | IllegalArgumentException | GitAPIException e) {
            FileUtils.deleteQuietly((File)this.localRepoFolder);
            throw new DeployerException("Failed to clone Git remote repository " + this.remoteRepoUrl + " into " + String.valueOf(this.localRepoFolder), e);
        }
    }

    protected boolean isRepositoryCorrupted(Throwable ex) {
        Throwable cause = ex.getCause();
        return cause instanceof CorruptObjectException || cause instanceof EOFException;
    }
}

