/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.git;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.craftercms.commons.git.utils.AuthConfiguratorFactory;
import org.craftercms.commons.git.utils.GitUtils;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.processors.git.AbstractRemoteGitRepoAwareProcessor;
import org.craftercms.deployer.impl.processors.git.GitPushProcessor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPushProcessor
extends AbstractRemoteGitRepoAwareProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GitPushProcessor.class);
    protected static final String FORCE_CONFIG_KEY = "force";
    protected static final String PUSH_ALL_CONFIG_KEY = "pushAll";
    protected static final String LOCAL_BRANCH_CONFIG_KEY = "localRepoBranch";
    protected boolean force;
    protected boolean pushAll;
    protected String localBranch;

    public GitPushProcessor(File localRepoFolder, AuthConfiguratorFactory authConfiguratorFactory) {
        super(localRepoFolder, authConfiguratorFactory);
    }

    protected void doInit(Configuration config) throws ConfigurationException {
        super.doInit(config);
        this.force = ConfigUtils.getBooleanProperty((Configuration)config, (String)FORCE_CONFIG_KEY, (Boolean)false);
        this.pushAll = ConfigUtils.getBooleanProperty((Configuration)config, (String)PUSH_ALL_CONFIG_KEY, (Boolean)false);
        this.localBranch = ConfigUtils.getStringProperty((Configuration)config, (String)LOCAL_BRANCH_CONFIG_KEY, (String)"HEAD");
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        File gitFolder = new File(this.localRepoFolder, ".git");
        if (this.localRepoFolder.exists() && gitFolder.exists()) {
            this.doPush(execution);
        } else {
            logger.warn("No local git repository @ {}", (Object)this.localRepoFolder);
        }
        return null;
    }

    protected void doPush(ProcessorExecution execution) throws DeployerException {
        try (Git git = this.openLocalRepository();){
            logger.info("Executing git push for repository {} (force = {})...", (Object)this.localRepoFolder, (Object)this.force);
            Iterable pushResults = GitUtils.push((Git)git, (String)this.remoteRepoUrl, (boolean)this.pushAll, (String)this.localBranch, (String)this.remoteRepoBranch, (GitAuthenticationConfigurator)this.authenticationConfigurator, (boolean)this.force);
            ArrayList detailsList = new ArrayList();
            boolean success = this.checkPushResults(pushResults, detailsList);
            if (CollectionUtils.isNotEmpty(detailsList)) {
                execution.setStatusDetails(detailsList);
                if (!success) {
                    execution.endExecution(Deployment.Status.FAILURE);
                }
            } else {
                execution.setStatusDetails((Object)"No result returned after push operation");
            }
        }
        catch (GitAPIException e) {
            throw new DeployerException("Execution of git push failed", (Throwable)e);
        }
    }

    protected boolean checkPushResults(Iterable<PushResult> pushResults, List<String> detailList) throws DeployerException {
        boolean success = true;
        if (pushResults != null) {
            for (PushResult result : pushResults) {
                Collection remoteRefUpdates = result.getRemoteUpdates();
                if (!CollectionUtils.isNotEmpty((Collection)remoteRefUpdates)) continue;
                for (RemoteRefUpdate update : remoteRefUpdates) {
                    if (this.checkRemoteRefUpdate(update, detailList)) continue;
                    success = false;
                }
            }
        }
        return success;
    }

    protected boolean checkRemoteRefUpdate(RemoteRefUpdate update, List<String> detailList) throws DeployerException {
        RemoteRefUpdate.Status status = update.getStatus();
        String updatedBranch = update.getRemoteName();
        switch (1.$SwitchMap$org$eclipse$jgit$transport$RemoteRefUpdate$Status[status.ordinal()]) {
            case 1: {
                String details = "Branch '" + updatedBranch + "' of remote repo " + this.remoteRepoUrl + " updated successfully (update with status " + String.valueOf(status) + ")";
                detailList.add(details);
                logger.info(details);
                return true;
            }
            case 2: {
                String details = "Branch '" + updatedBranch + "' of remote repo " + this.remoteRepoUrl + " already up to date (update with status " + String.valueOf(status) + ")";
                detailList.add(details);
                logger.info(details);
                return true;
            }
        }
        String details = "Received unexpected result after executing push: " + String.valueOf(status);
        detailList.add(details);
        logger.error(details);
        return false;
    }
}

