/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.processors.git;

import java.beans.ConstructorProperties;
import org.apache.commons.configuration2.Configuration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.ChangeSet;
import org.craftercms.deployer.api.Deployment;
import org.craftercms.deployer.api.ProcessorExecution;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.impl.ProcessedCommitsStore;
import org.craftercms.deployer.impl.processors.AbstractMainDeploymentProcessor;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitUpdateCommitIdProcessor
extends AbstractMainDeploymentProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GitUpdateCommitIdProcessor.class);
    protected ProcessedCommitsStore processedCommitsStore;

    @ConstructorProperties(value={"processedCommitsStore"})
    public GitUpdateCommitIdProcessor(ProcessedCommitsStore processedCommitsStore) {
        this.processedCommitsStore = processedCommitsStore;
    }

    protected ChangeSet doMainProcess(Deployment deployment, ProcessorExecution execution, ChangeSet filteredChangeSet, ChangeSet originalChangeSet) throws DeployerException {
        ObjectId commitId = (ObjectId)deployment.getParam("latest_commit_id");
        if (commitId != null) {
            logger.info("Updating processed commit to {}", (Object)commitId.name());
            this.processedCommitsStore.store(this.targetId, commitId);
        }
        return null;
    }

    protected void doInit(Configuration config) throws ConfigurationException, DeployerException {
    }

    protected void doDestroy() throws DeployerException {
    }
}

