/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.rest;

import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.stream.Collectors;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.commons.rest.RestServiceUtils;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.rest.ValidationAwareRestExceptionHandlers;
import org.craftercms.core.controller.rest.ValidationFieldError;
import org.craftercms.deployer.api.exceptions.TargetAlreadyExistsException;
import org.craftercms.deployer.api.exceptions.TargetNotFoundException;
import org.craftercms.deployer.api.exceptions.TargetNotReadyException;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

@Order(value=-2147483648)
@ControllerAdvice
public class ExceptionHandlers
extends ValidationAwareRestExceptionHandlers {
    @ExceptionHandler(value={TargetNotFoundException.class})
    public ResponseEntity<Object> handleTargetNotFoundException(TargetNotFoundException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, "Target not found", new HttpHeaders(), HttpStatus.NOT_FOUND, request);
    }

    @ExceptionHandler(value={TargetAlreadyExistsException.class})
    public ResponseEntity<Object> handleTargetAlreadyExistsException(TargetAlreadyExistsException ex, WebRequest request) {
        HttpHeaders headers = RestServiceUtils.setLocationHeader((HttpHeaders)new HttpHeaders(), (String)"/api/1/target/get/{env}/{site_name}", (Object[])new Object[]{ex.getEnv(), ex.getSiteName()});
        return this.handleExceptionInternal((Exception)ex, "Target already exists", headers, HttpStatus.CONFLICT, request);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Object> handleConstraintValidationException(ConstraintViolationException e, WebRequest request) {
        List result = e.getConstraintViolations().stream().map(c -> new ValidationFieldError(c.getPropertyPath().toString(), c.getMessage())).collect(Collectors.toList());
        return ResponseEntity.badRequest().body(result);
    }

    @ExceptionHandler(value={InvalidManagementTokenException.class})
    public ResponseEntity<Object> handleInvalidManagementTokenException(InvalidManagementTokenException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, "Invalid management token", new HttpHeaders(), HttpStatus.UNAUTHORIZED, request);
    }

    @ExceptionHandler(value={TargetNotReadyException.class})
    public ResponseEntity<Object> handleTargetNotReadyException(TargetNotReadyException ex, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, ex.getMessage(), new HttpHeaders(), HttpStatus.SERVICE_UNAVAILABLE, request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ValidationResult result = new ValidationResult();
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            result.addError(fieldError.getField(), fieldError.getDefaultMessage(), new Object[0]);
        }
        return this.handleExceptionInternal((Exception)ex, (Object)result, new HttpHeaders(), (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
    }
}

