/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.target.event;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.exceptions.DeployerException;
import org.craftercms.deployer.api.target.event.TargetEventListener;
import org.craftercms.deployer.api.target.event.TargetEventListenerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;

@Component
public class TargetEventListenerResolverImpl
implements TargetEventListenerResolver {
    private static final Logger logger = LoggerFactory.getLogger(TargetEventListenerResolverImpl.class);

    public Map<String, List<TargetEventListener>> getListeners(HierarchicalConfiguration<ImmutableNode> configuration, ApplicationContext applicationContext, String eventListenerPropertyName) throws ConfigurationException, DeployerException {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        List eventConfigs = configuration.configurationsAt(eventListenerPropertyName);
        if (!CollectionUtils.isNotEmpty((Collection)eventConfigs)) {
            logger.info("No event configured for property '{}'.", (Object)eventListenerPropertyName);
            return result;
        }
        for (HierarchicalConfiguration eventConfig : eventConfigs) {
            String eventName = ConfigUtils.getRequiredStringProperty((Configuration)eventConfig, (String)"eventName");
            List listeners = eventConfig.configurationsAt("listeners");
            for (HierarchicalConfiguration listenerConfig : listeners) {
                String listenerName = ConfigUtils.getRequiredStringProperty((Configuration)listenerConfig, (String)"name");
                logger.debug("Initializing target event listener '{}'", (Object)listenerName);
                try {
                    TargetEventListener listener = (TargetEventListener)applicationContext.getBean(listenerName, TargetEventListener.class);
                    listener.init((Configuration)listenerConfig, applicationContext);
                    result.add((Object)eventName, (Object)listener);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new DeployerException("Target event listener '" + listenerName + "' not found in application context", (Throwable)e);
                }
                catch (Exception e) {
                    throw new DeployerException("Failed to initialize target event listener '" + listenerName + "'", (Throwable)e);
                }
            }
        }
        return result;
    }
}

