/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.tasks;

import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.api.TargetService;
import org.craftercms.deployer.api.exceptions.TargetServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"deployer.main.targets.cleanup.enabled"})
public class TargetCleanupTask {
    private static final Logger logger = LoggerFactory.getLogger(TargetCleanupTask.class);
    @Autowired
    protected TargetService targetService;

    @Scheduled(cron="${deployer.main.targets.cleanup.cron}")
    public void cleanupAllTargets() {
        try {
            logger.info("Starting cleanup for all targets");
            this.targetService.getAllTargets().forEach(Target::cleanRepo);
        }
        catch (TargetServiceException e) {
            logger.error("Error getting loaded targets", (Throwable)e);
        }
    }
}

