/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.impl.upgrade.operations.ProcessorPresentUpgradeOperation;

public class AddLifecycleHookUpgradeOperation
extends ProcessorPresentUpgradeOperation {
    public static final String CONFIG_KEY_HOOK_TYPE = "hookType";
    protected String hookType;
    protected String hookName;

    protected void doInit(HierarchicalConfiguration<?> config) throws ConfigurationException {
        this.hookType = ConfigUtils.getRequiredStringProperty(config, (String)CONFIG_KEY_HOOK_TYPE);
        this.hookName = ConfigUtils.getRequiredStringProperty(config, (String)"hookName");
    }

    protected void doExecuteInternal(Target target, Map<String, Object> targetConfig) {
        LinkedList<Map<String, String>> hooks;
        Map targetObj = (Map)targetConfig.get("target");
        HashMap lifecycle = (HashMap)targetObj.get("lifecycleHooks");
        if (lifecycle == null) {
            lifecycle = new HashMap();
            targetObj.put("lifecycleHooks", lifecycle);
        }
        if ((hooks = (LinkedList<Map<String, String>>)lifecycle.get(this.hookType)) == null) {
            hooks = new LinkedList<Map<String, String>>();
            lifecycle.put(this.hookType, hooks);
        }
        if (hooks.stream().noneMatch(hook -> StringUtils.equals((CharSequence)this.hookName, (CharSequence)hook.get("hookName").toString()))) {
            hooks.add(Collections.singletonMap("hookName", this.hookName));
        } else {
            this.logger.info("Target '{}' already has lifecycle hook '{}.{}'", new Object[]{target.getId(), this.hookType, this.hookName});
        }
    }
}

