/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.impl.upgrade.operations.AbstractProcessorUpgradeOperation;

public class ProcessorUpgradeOperation
extends AbstractProcessorUpgradeOperation {
    protected List<Map<String, String>> replacements;
    protected List<Map<String, String>> removals;
    protected List<Map<String, Object>> additions;

    protected void doInit(HierarchicalConfiguration<?> config) throws ConfigurationException {
        HashMap<String, Object> map;
        this.removals = new LinkedList();
        for (HierarchicalConfiguration removeConfig : config.configurationsAt("remove")) {
            map = new HashMap<String, Object>();
            map.put("property", ConfigUtils.getRequiredStringProperty((Configuration)removeConfig, (String)"property"));
            map.put("pattern", ConfigUtils.getRequiredStringProperty((Configuration)removeConfig, (String)"pattern"));
            this.removals.add(map);
        }
        this.replacements = new LinkedList();
        for (HierarchicalConfiguration replacementConfig : config.configurationsAt("replace")) {
            map = new HashMap();
            map.put("property", ConfigUtils.getRequiredStringProperty((Configuration)replacementConfig, (String)"property"));
            map.put("pattern", ConfigUtils.getRequiredStringProperty((Configuration)replacementConfig, (String)"pattern"));
            map.put("expression", ConfigUtils.getRequiredStringProperty((Configuration)replacementConfig, (String)"expression"));
            this.replacements.add(map);
        }
        this.additions = new LinkedList();
        for (HierarchicalConfiguration additionConfig : config.configurationsAt("add")) {
            map = new HashMap();
            map.put("property", ConfigUtils.getRequiredStringProperty((Configuration)additionConfig, (String)"property"));
            if (additionConfig.containsKey("value")) {
                map.put("value", ConfigUtils.getRequiredStringProperty((Configuration)additionConfig, (String)"value"));
            } else if (additionConfig.containsKey("values")) {
                map.put("values", additionConfig.getList("values"));
            }
            this.additions.add(map);
        }
    }

    protected void doExecuteInternal(Target target, Map<String, Object> targetConfig) {
        this.getPipeline(targetConfig).stream().filter(processor -> processor.get("processorName").toString().matches(this.processorName)).forEach(processor -> {
            String name = processor.get("processorName").toString();
            this.logger.debug("Running removals for processor '{}' in target '{}'", (Object)name, (Object)target);
            this.removals.forEach(config -> {
                String property = (String)config.get("property");
                if (processor.containsKey(property)) {
                    String pattern = (String)config.get("pattern");
                    String propertyValue = processor.get(property).toString();
                    if (propertyValue.matches(pattern)) {
                        this.logger.trace("Removing property '{}' for processor '{}' in target '{}'", new Object[]{property, name, target});
                        processor.remove(property);
                    }
                }
            });
            this.logger.debug("Running replacements for processor '{}' in target '{}'", (Object)name, (Object)target);
            this.replacements.forEach(config -> {
                String property = (String)config.get("property");
                if (processor.containsKey(property)) {
                    String pattern = (String)config.get("pattern");
                    String expression = (String)config.get("expression");
                    this.logger.trace("Replacing property '{}' for processor '{}' in target '{}'", new Object[]{property, name, target});
                    processor.put(property, processor.get(property).toString().replaceAll(pattern, expression));
                }
            });
            this.logger.debug("Running additions for processor '{}' in target '{}'", (Object)name, (Object)target);
            this.additions.forEach(config -> {
                String property = (String)config.get("property");
                if (config.containsKey("value")) {
                    processor.put(property, config.get("value"));
                } else if (processor.containsKey(property)) {
                    List list = (List)processor.get(property);
                    list.addAll((List)config.get("values"));
                } else {
                    processor.put(property, config.get("values"));
                }
            });
        });
    }
}

