/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.impl.upgrade.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.api.Target;
import org.craftercms.deployer.impl.upgrade.operations.AbstractProcessorUpgradeOperation;

public class ReplaceProcessorUpgradeOperation
extends AbstractProcessorUpgradeOperation {
    public static final String CONFIG_KEY_CONDITIONS = "conditions";
    public static final String CONFIG_KEY_NEW_PROCESSOR = "newProcessor";
    public static final String CONFIG_KEY_DELETE_PROPERTIES = "deleteProperties";
    protected Map<String, String> conditions;
    protected String newProcessorName;
    protected List<String> deleteProperties;

    protected void doInit(HierarchicalConfiguration config) throws ConfigurationException {
        this.conditions = new HashMap();
        List conditionConfig = config.configurationsAt(CONFIG_KEY_CONDITIONS);
        if (!conditionConfig.isEmpty()) {
            Iterator it = ((HierarchicalConfiguration)conditionConfig.get(0)).getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.conditions.put(key, ((HierarchicalConfiguration)conditionConfig.get(0)).getString(key));
            }
        }
        this.newProcessorName = ConfigUtils.getRequiredStringProperty((Configuration)config, (String)CONFIG_KEY_NEW_PROCESSOR);
        this.deleteProperties = config.getList(String.class, CONFIG_KEY_DELETE_PROPERTIES, Collections.emptyList());
    }

    protected boolean matchesAllConditions(Map<String, Object> processorObj) {
        if (processorObj.get("processorName").equals(this.processorName)) {
            for (String property : this.conditions.keySet()) {
                if (processorObj.containsKey(property) && processorObj.get(property).toString().matches((String)this.conditions.get(property))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void doExecuteInternal(Target target, Map<String, Object> targetConfig) {
        List pipelineObj = this.getPipeline(targetConfig);
        for (Map processorObj : pipelineObj) {
            if (!this.matchesAllConditions(processorObj)) continue;
            processorObj.put("processorName", this.newProcessorName);
            this.deleteProperties.forEach(processorObj::remove);
        }
    }
}

