/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.deployer.utils.opensearch;

import java.util.ArrayList;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.deployer.utils.opensearch.OpenSearchClusterConfig;
import org.craftercms.deployer.utils.opensearch.OpenSearchConfig;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractOpenSearchFactory<T>
extends AbstractFactoryBean<T>
implements BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpenSearchFactory.class);
    protected String name;
    protected OpenSearchConfig config;

    public AbstractOpenSearchFactory(OpenSearchConfig config) {
        this.config = config;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    protected T createInstance() throws ConfigurationException {
        logger.debug("Creating instance for '{}'", (Object)this.name);
        if (this.config.useSingleCluster()) {
            logger.debug("Using a single cluster configuration for '{}'", (Object)this.name);
            return (T)this.doCreateSingleInstance(this.config.globalCluster.buildClient());
        }
        logger.debug("Using a multi-cluster configuration for '{}'", (Object)this.name);
        ArrayList<OpenSearchClient> writeClientList = new ArrayList<OpenSearchClient>(this.config.writeClusters.size());
        try {
            for (OpenSearchClusterConfig writeCluster : this.config.writeClusters) {
                writeClientList.add(writeCluster.buildClient());
            }
            OpenSearchClient readClient = this.config.readCluster.buildClient();
            return (T)this.doCreateMultiInstance(readClient, writeClientList.toArray(new OpenSearchClient[0]));
        }
        catch (ConfigurationException e) {
            AbstractOpenSearchFactory.closeClients(writeClientList);
            throw e;
        }
    }

    private static void closeClients(ArrayList<OpenSearchClient> writeClientList) {
        for (OpenSearchClient writeClient : writeClientList) {
            try {
                ((OpenSearchTransport)writeClient._transport()).close();
            }
            catch (Exception ex) {
                logger.warn("Failed to close write client during cleanup", (Throwable)ex);
            }
        }
    }

    protected abstract T doCreateSingleInstance(OpenSearchClient var1);

    protected abstract T doCreateMultiInstance(OpenSearchClient var1, OpenSearchClient[] var2);
}

