/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IngestionSourcePointer;
import org.opensearch.client.opensearch.indices.IngestionSourcePointerInitReset;
import org.opensearch.client.opensearch.indices.IngestionSourcePoll;
import org.opensearch.client.opensearch.indices.IngestionSourceType;
import org.opensearch.client.opensearch.ingestion.ErrorPolicy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IngestionSource
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IngestionSource> {
    @Nullable
    private final ErrorPolicy errorStrategy;
    @Nullable
    private final Integer internalQueueSize;
    @Nullable
    private final Integer numProcessorThreads;
    @Nonnull
    private final Map<String, String> param;
    @Nullable
    private final IngestionSourcePointer pointer;
    @Nullable
    private final IngestionSourcePointerInitReset pointerInitReset;
    @Nullable
    private final String pointerInitResetValue;
    @Nullable
    private final IngestionSourcePoll poll;
    @Nullable
    private final Long pollMaxBatchSize;
    @Nullable
    private final Integer pollTimeout;
    @Nullable
    private final IngestionSourceType type;
    public static final JsonpDeserializer<IngestionSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestionSource::setupIngestionSourceDeserializer);

    private IngestionSource(Builder builder) {
        this.errorStrategy = builder.errorStrategy;
        this.internalQueueSize = builder.internalQueueSize;
        this.numProcessorThreads = builder.numProcessorThreads;
        this.param = ApiTypeHelper.unmodifiable(builder.param);
        this.pointer = builder.pointer;
        this.pointerInitReset = builder.pointerInitReset;
        this.pointerInitResetValue = builder.pointerInitResetValue;
        this.poll = builder.poll;
        this.pollMaxBatchSize = builder.pollMaxBatchSize;
        this.pollTimeout = builder.pollTimeout;
        this.type = builder.type;
    }

    public static IngestionSource of(Function<Builder, ObjectBuilder<IngestionSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ErrorPolicy errorStrategy() {
        return this.errorStrategy;
    }

    @Nullable
    public final Integer internalQueueSize() {
        return this.internalQueueSize;
    }

    @Nullable
    public final Integer numProcessorThreads() {
        return this.numProcessorThreads;
    }

    @Nonnull
    public final Map<String, String> param() {
        return this.param;
    }

    @Nullable
    public final IngestionSourcePointer pointer() {
        return this.pointer;
    }

    @Nullable
    public final IngestionSourcePointerInitReset pointerInitReset() {
        return this.pointerInitReset;
    }

    @Nullable
    public final String pointerInitResetValue() {
        return this.pointerInitResetValue;
    }

    @Nullable
    public final IngestionSourcePoll poll() {
        return this.poll;
    }

    @Nullable
    public final Long pollMaxBatchSize() {
        return this.pollMaxBatchSize;
    }

    @Nullable
    public final Integer pollTimeout() {
        return this.pollTimeout;
    }

    @Nullable
    public final IngestionSourceType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.errorStrategy != null) {
            generator.writeKey("error_strategy");
            this.errorStrategy.serialize(generator, mapper);
        }
        if (this.internalQueueSize != null) {
            generator.writeKey("internal_queue_size");
            generator.write(this.internalQueueSize.intValue());
        }
        if (this.numProcessorThreads != null) {
            generator.writeKey("num_processor_threads");
            generator.write(this.numProcessorThreads.intValue());
        }
        if (ApiTypeHelper.isDefined(this.param)) {
            generator.writeKey("param");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.param.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.pointer != null) {
            generator.writeKey("pointer");
            this.pointer.serialize(generator, mapper);
        }
        if (this.pointerInitReset != null) {
            generator.writeKey("pointer.init.reset");
            this.pointerInitReset.serialize(generator, mapper);
        }
        if (this.pointerInitResetValue != null) {
            generator.writeKey("pointer.init.reset.value");
            generator.write(this.pointerInitResetValue);
        }
        if (this.poll != null) {
            generator.writeKey("poll");
            this.poll.serialize(generator, mapper);
        }
        if (this.pollMaxBatchSize != null) {
            generator.writeKey("poll.max_batch_size");
            generator.write(this.pollMaxBatchSize.longValue());
        }
        if (this.pollTimeout != null) {
            generator.writeKey("poll.timeout");
            generator.write(this.pollTimeout.intValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIngestionSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errorStrategy, ErrorPolicy._DESERIALIZER, "error_strategy");
        op.add(Builder::internalQueueSize, JsonpDeserializer.integerDeserializer(), "internal_queue_size");
        op.add(Builder::numProcessorThreads, JsonpDeserializer.integerDeserializer(), "num_processor_threads");
        op.add(Builder::param, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "param");
        op.add(Builder::pointer, IngestionSourcePointer._DESERIALIZER, "pointer");
        op.add(Builder::pointerInitReset, IngestionSourcePointerInitReset._DESERIALIZER, "pointer.init.reset");
        op.add(Builder::pointerInitResetValue, JsonpDeserializer.stringDeserializer(), "pointer.init.reset.value");
        op.add(Builder::poll, IngestionSourcePoll._DESERIALIZER, "poll");
        op.add(Builder::pollMaxBatchSize, JsonpDeserializer.longDeserializer(), "poll.max_batch_size");
        op.add(Builder::pollTimeout, JsonpDeserializer.integerDeserializer(), "poll.timeout");
        op.add(Builder::type, IngestionSourceType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.errorStrategy);
        result = 31 * result + Objects.hashCode(this.internalQueueSize);
        result = 31 * result + Objects.hashCode(this.numProcessorThreads);
        result = 31 * result + Objects.hashCode(this.param);
        result = 31 * result + Objects.hashCode(this.pointer);
        result = 31 * result + Objects.hashCode(this.pointerInitReset);
        result = 31 * result + Objects.hashCode(this.pointerInitResetValue);
        result = 31 * result + Objects.hashCode(this.poll);
        result = 31 * result + Objects.hashCode(this.pollMaxBatchSize);
        result = 31 * result + Objects.hashCode(this.pollTimeout);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestionSource other = (IngestionSource)o;
        return Objects.equals(this.errorStrategy, other.errorStrategy) && Objects.equals(this.internalQueueSize, other.internalQueueSize) && Objects.equals(this.numProcessorThreads, other.numProcessorThreads) && Objects.equals(this.param, other.param) && Objects.equals(this.pointer, other.pointer) && Objects.equals(this.pointerInitReset, other.pointerInitReset) && Objects.equals(this.pointerInitResetValue, other.pointerInitResetValue) && Objects.equals(this.poll, other.poll) && Objects.equals(this.pollMaxBatchSize, other.pollMaxBatchSize) && Objects.equals(this.pollTimeout, other.pollTimeout) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IngestionSource> {
        @Nullable
        private ErrorPolicy errorStrategy;
        @Nullable
        private Integer internalQueueSize;
        @Nullable
        private Integer numProcessorThreads;
        @Nullable
        private Map<String, String> param;
        @Nullable
        private IngestionSourcePointer pointer;
        @Nullable
        private IngestionSourcePointerInitReset pointerInitReset;
        @Nullable
        private String pointerInitResetValue;
        @Nullable
        private IngestionSourcePoll poll;
        @Nullable
        private Long pollMaxBatchSize;
        @Nullable
        private Integer pollTimeout;
        @Nullable
        private IngestionSourceType type;

        public Builder() {
        }

        private Builder(IngestionSource o) {
            this.errorStrategy = o.errorStrategy;
            this.internalQueueSize = o.internalQueueSize;
            this.numProcessorThreads = o.numProcessorThreads;
            this.param = Builder._mapCopy(o.param);
            this.pointer = o.pointer;
            this.pointerInitReset = o.pointerInitReset;
            this.pointerInitResetValue = o.pointerInitResetValue;
            this.poll = o.poll;
            this.pollMaxBatchSize = o.pollMaxBatchSize;
            this.pollTimeout = o.pollTimeout;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.errorStrategy = o.errorStrategy;
            this.internalQueueSize = o.internalQueueSize;
            this.numProcessorThreads = o.numProcessorThreads;
            this.param = Builder._mapCopy(o.param);
            this.pointer = o.pointer;
            this.pointerInitReset = o.pointerInitReset;
            this.pointerInitResetValue = o.pointerInitResetValue;
            this.poll = o.poll;
            this.pollMaxBatchSize = o.pollMaxBatchSize;
            this.pollTimeout = o.pollTimeout;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder errorStrategy(@Nullable ErrorPolicy value) {
            this.errorStrategy = value;
            return this;
        }

        @Nonnull
        public final Builder internalQueueSize(@Nullable Integer value) {
            this.internalQueueSize = value;
            return this;
        }

        @Nonnull
        public final Builder numProcessorThreads(@Nullable Integer value) {
            this.numProcessorThreads = value;
            return this;
        }

        @Nonnull
        public final Builder param(Map<String, String> map) {
            this.param = Builder._mapPutAll(this.param, map);
            return this;
        }

        @Nonnull
        public final Builder param(String key, String value) {
            this.param = Builder._mapPut(this.param, key, value);
            return this;
        }

        @Nonnull
        public final Builder pointer(@Nullable IngestionSourcePointer value) {
            this.pointer = value;
            return this;
        }

        @Nonnull
        public final Builder pointer(Function<IngestionSourcePointer.Builder, ObjectBuilder<IngestionSourcePointer>> fn) {
            return this.pointer(fn.apply(new IngestionSourcePointer.Builder()).build());
        }

        @Nonnull
        public final Builder pointerInitReset(@Nullable IngestionSourcePointerInitReset value) {
            this.pointerInitReset = value;
            return this;
        }

        @Nonnull
        public final Builder pointerInitResetValue(@Nullable String value) {
            this.pointerInitResetValue = value;
            return this;
        }

        @Nonnull
        public final Builder poll(@Nullable IngestionSourcePoll value) {
            this.poll = value;
            return this;
        }

        @Nonnull
        public final Builder poll(Function<IngestionSourcePoll.Builder, ObjectBuilder<IngestionSourcePoll>> fn) {
            return this.poll(fn.apply(new IngestionSourcePoll.Builder()).build());
        }

        @Nonnull
        public final Builder pollMaxBatchSize(@Nullable Long value) {
            this.pollMaxBatchSize = value;
            return this;
        }

        @Nonnull
        public final Builder pollTimeout(@Nullable Integer value) {
            this.pollTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable IngestionSourceType value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public IngestionSource build() {
            this._checkSingleUse();
            return new IngestionSource(this);
        }
    }
}

