/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.executors.ExperimentTaskManager;
import org.opensearch.searchrelevance.experiment.HybridOptimizerExperimentProcessor;
import org.opensearch.searchrelevance.experiment.PointwiseExperimentProcessor;
import org.opensearch.searchrelevance.metrics.MetricsHelper;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.QuerySetEntry;
import org.opensearch.searchrelevance.model.SearchConfiguration;
import org.opensearch.searchrelevance.model.SearchConfigurationDetails;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class PutExperimentTransportAction
extends HandledTransportAction<PutExperimentRequest, IndexResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(PutExperimentTransportAction.class);
    private final ExperimentDao experimentDao;
    private final QuerySetDao querySetDao;
    private final SearchConfigurationDao searchConfigurationDao;
    private final MetricsHelper metricsHelper;
    private final HybridOptimizerExperimentProcessor hybridOptimizerExperimentProcessor;
    private final PointwiseExperimentProcessor pointwiseExperimentProcessor;

    @Inject
    public PutExperimentTransportAction(TransportService transportService, ActionFilters actionFilters, ExperimentDao experimentDao, QuerySetDao querySetDao, SearchConfigurationDao searchConfigurationDao, MetricsHelper metricsHelper, JudgmentDao judgmentDao, ExperimentTaskManager experimentTaskManager) {
        super("cluster:admin/opensearch/search_relevance/experiment/create", transportService, actionFilters, PutExperimentRequest::new);
        this.experimentDao = experimentDao;
        this.querySetDao = querySetDao;
        this.searchConfigurationDao = searchConfigurationDao;
        this.metricsHelper = metricsHelper;
        this.hybridOptimizerExperimentProcessor = new HybridOptimizerExperimentProcessor(judgmentDao, experimentTaskManager);
        this.pointwiseExperimentProcessor = new PointwiseExperimentProcessor(judgmentDao, experimentTaskManager);
    }

    protected void doExecute(Task task, PutExperimentRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            String id = UUID.randomUUID().toString();
            Experiment initialExperiment = new Experiment(id, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.PROCESSING, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), new ArrayList<Map<String, Object>>());
            this.experimentDao.putExperiment(initialExperiment, ActionListener.wrap(response -> {
                listener.onResponse((Object)((IndexResponse)response));
                this.triggerAsyncProcessing(id, request);
            }, e -> {
                log.error("Failed to create initial experiment", (Throwable)e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to create initial experiment", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (Exception e2) {
            log.error("Failed to process experiment request", (Throwable)e2);
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to process experiment request", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    private void triggerAsyncProcessing(String experimentId, PutExperimentRequest request) {
        this.querySetDao.getQuerySet(request.getQuerySetId(), (ActionListener<SearchResponse>)ActionListener.wrap(querySetResponse -> {
            try {
                QuerySet querySet = this.convertToQuerySet((SearchResponse)querySetResponse);
                List<String> queryTextWithReferences = querySet.querySetQueries().stream().map(e -> e.queryText()).collect(Collectors.toList());
                if (queryTextWithReferences.isEmpty()) {
                    log.info("Experiment {} completed with 0 query texts", (Object)experimentId);
                    this.updateFinalExperiment(experimentId, request, new ArrayList<Map<String, Object>>(), request.getJudgmentList());
                    return;
                }
                this.fetchSearchConfigurationsAsync(experimentId, request, queryTextWithReferences);
            }
            catch (Exception e2) {
                this.handleAsyncFailure(experimentId, request, "Failed to process QuerySet", e2);
            }
        }, e -> this.handleAsyncFailure(experimentId, request, "Failed to fetch QuerySet", (Exception)e)));
    }

    private void fetchSearchConfigurationsAsync(String experimentId, PutExperimentRequest request, List<String> queryTextWithReferences) {
        HashMap searchConfigurations = new HashMap();
        AtomicInteger pendingConfigs = new AtomicInteger(request.getSearchConfigurationList().size());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        for (String configId : request.getSearchConfigurationList()) {
            this.searchConfigurationDao.getSearchConfiguration(configId, (ActionListener<SearchResponse>)ActionListener.wrap(searchConfigResponse -> {
                block7: {
                    try {
                        if (hasFailure.get()) {
                            return;
                        }
                        SearchConfiguration config = this.convertToSearchConfiguration((SearchResponse)searchConfigResponse);
                        Map map = searchConfigurations;
                        synchronized (map) {
                            searchConfigurations.put(config.id(), SearchConfigurationDetails.builder().index(config.index()).query(config.query()).pipeline(config.searchPipeline()).build());
                        }
                        if (pendingConfigs.decrementAndGet() == 0) {
                            this.calculateMetricsAsync(experimentId, request, searchConfigurations, queryTextWithReferences);
                        }
                    }
                    catch (Exception e) {
                        if (!hasFailure.compareAndSet(false, true)) break block7;
                        this.handleAsyncFailure(experimentId, request, "Failed to process SearchConfiguration", e);
                    }
                }
            }, e -> {
                if (hasFailure.compareAndSet(false, true)) {
                    this.handleAsyncFailure(experimentId, request, "Failed to fetch SearchConfiguration: " + configId, (Exception)e);
                }
            }));
        }
    }

    private QuerySet convertToQuerySet(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("QuerySet not found", RestStatus.NOT_FOUND);
        }
        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
        ArrayList<QuerySetEntry> querySetEntries = new ArrayList();
        Object querySetQueriesObj = sourceMap.get("querySetQueries");
        if (querySetQueriesObj instanceof List) {
            List querySetQueriesList = (List)querySetQueriesObj;
            querySetEntries = querySetQueriesList.stream().map(entryMap -> QuerySetEntry.Builder.builder().queryText((String)entryMap.get("queryText")).build()).collect(Collectors.toList());
        }
        return QuerySet.Builder.builder().id((String)sourceMap.get("id")).name((String)sourceMap.get("name")).description((String)sourceMap.get("description")).timestamp((String)sourceMap.get("timestamp")).sampling((String)sourceMap.get("sampling")).querySetQueries(querySetEntries).build();
    }

    private SearchConfiguration convertToSearchConfiguration(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("SearchConfiguration not found", RestStatus.NOT_FOUND);
        }
        Map source = response.getHits().getHits()[0].getSourceAsMap();
        return new SearchConfiguration((String)source.get("id"), (String)source.get("name"), (String)source.get("timestamp"), (String)source.get("index"), (String)source.get("query"), (String)source.get("searchPipeline"));
    }

    private void calculateMetricsAsync(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTextWithReferences) {
        if (queryTextWithReferences == null || searchConfigurations == null) {
            throw new IllegalStateException("Missing required data for metrics calculation");
        }
        this.processQueryTextMetrics(experimentId, request, searchConfigurations, queryTextWithReferences);
    }

    private void processQueryTextMetrics(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTexts) {
        List<Map<String, Object>> finalResults = Collections.synchronizedList(new ArrayList());
        AtomicInteger pendingQueries = new AtomicInteger(queryTexts.size());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        this.executeExperimentEvaluation(experimentId, request, searchConfigurations, queryTexts, finalResults, pendingQueries, hasFailure, request.getJudgmentList());
    }

    private void executeExperimentEvaluation(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTexts, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, AtomicBoolean hasFailure, List<String> judgmentList) {
        for (String queryText : queryTexts) {
            if (hasFailure.get()) {
                return;
            }
            if (request.getType() == ExperimentType.PAIRWISE_COMPARISON) {
                this.metricsHelper.processPairwiseMetrics(queryText, searchConfigurations, request.getSize(), (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)));
                continue;
            }
            if (request.getType() == ExperimentType.HYBRID_OPTIMIZER) {
                this.hybridOptimizerExperimentProcessor.processHybridOptimizerExperiment(experimentId, queryText, searchConfigurations, judgmentList, request.getSize(), hasFailure, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)));
                continue;
            }
            if (request.getType() == ExperimentType.POINTWISE_EVALUATION) {
                this.pointwiseExperimentProcessor.processPointwiseExperiment(experimentId, queryText, searchConfigurations, judgmentList, request.getSize(), hasFailure, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request)));
                continue;
            }
            throw new SearchRelevanceException("Unknown experimentType" + String.valueOf((Object)request.getType()), RestStatus.BAD_REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryResults(String queryText, Map<String, Object> queryResults, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, String experimentId, PutExperimentRequest request, AtomicBoolean hasFailure, List<String> judgmentList) {
        if (hasFailure.get()) {
            return;
        }
        try {
            List<Map<String, Object>> list = finalResults;
            synchronized (list) {
                if (request.getType() == ExperimentType.HYBRID_OPTIMIZER) {
                    List searchConfigResults = (List)queryResults.get("searchConfigurationResults");
                    if (searchConfigResults != null) {
                        for (Map configResult : searchConfigResults) {
                            HashMap<String, String> resultWithQuery = new HashMap<String, String>(configResult);
                            resultWithQuery.put("queryText", queryText);
                            finalResults.add(resultWithQuery);
                        }
                    }
                } else if (request.getType() == ExperimentType.POINTWISE_EVALUATION) {
                    List pointwiseResults = (List)queryResults.get("results");
                    if (pointwiseResults != null) {
                        finalResults.addAll(pointwiseResults);
                    }
                } else {
                    queryResults.put("queryText", queryText);
                    finalResults.add(queryResults);
                }
                if (pendingQueries.decrementAndGet() == 0) {
                    this.updateFinalExperiment(experimentId, request, finalResults, judgmentList);
                }
            }
        }
        catch (Exception e) {
            this.handleFailure(e, hasFailure, experimentId, request);
        }
    }

    private void handleFailure(Exception error, AtomicBoolean hasFailure, String experimentId, PutExperimentRequest request) {
        if (hasFailure.compareAndSet(false, true)) {
            this.handleAsyncFailure(experimentId, request, "Failed to process metrics", error);
        }
    }

    private void updateFinalExperiment(String experimentId, PutExperimentRequest request, List<Map<String, Object>> finalResults, List<String> judgmentList) {
        Experiment finalExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.COMPLETED, request.getQuerySetId(), request.getSearchConfigurationList(), judgmentList, request.getSize(), finalResults);
        this.experimentDao.updateExperiment(finalExperiment, ActionListener.wrap(response -> log.debug("Updated final experiment: {}", (Object)experimentId), error -> this.handleAsyncFailure(experimentId, request, "Failed to update final experiment", (Exception)error)));
    }

    private void handleAsyncFailure(String experimentId, PutExperimentRequest request, String message, Exception error) {
        log.error(message + " for experiment: " + experimentId, (Throwable)error);
        Experiment errorExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.ERROR, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), List.of(Map.of("error", error.getMessage())));
        this.experimentDao.updateExperiment(errorExperiment, ActionListener.wrap(response -> log.info("Updated experiment {} status to ERROR", (Object)experimentId), e -> log.error("Failed to update error status for experiment: " + experimentId, (Throwable)e)));
    }
}

