/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.queryset;

import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteQuerySetTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final QuerySetDao querySetDao;

    @Inject
    public DeleteQuerySetTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, QuerySetDao querySetDao) {
        super("cluster:admin/opensearch/search_relevance/queryset/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.querySetDao = querySetDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, ActionListener<DeleteResponse> listener) {
        try {
            String querySetId = request.getId();
            if (querySetId == null || querySetId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Query set ID cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.querySetDao.deleteQuerySet(querySetId, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

