/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogOperationHelper;
import org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteFsTimestampAwareTranslog
extends RemoteFsTranslog {
    private static Logger staticLogger = LogManager.getLogger(RemoteFsTimestampAwareTranslog.class);
    private final Logger logger;
    private final Map<Long, String> metadataFilePinnedTimestampMap;
    private final Map<String, Tuple<Long, Long>> oldFormatMetadataFileGenerationMap;
    private final Map<String, Tuple<Long, Long>> oldFormatMetadataFilePrimaryTermMap;
    private final AtomicLong minPrimaryTermInRemote = new AtomicLong(Long.MAX_VALUE);
    private final AtomicBoolean triggerTrimOnMinRemoteGenReferencedChange = new AtomicBoolean(false);

    public RemoteFsTimestampAwareTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BlobStoreRepository blobStoreRepository, ThreadPool threadPool, BooleanSupplier startedPrimarySupplier, RemoteTranslogTransferTracker remoteTranslogTransferTracker, RemoteStoreSettings remoteStoreSettings, TranslogOperationHelper translogOperationHelper) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, blobStoreRepository, threadPool, startedPrimarySupplier, remoteTranslogTransferTracker, remoteStoreSettings, translogOperationHelper, null);
        this.logger = Loggers.getLogger(this.getClass(), this.shardId, new String[0]);
        this.metadataFilePinnedTimestampMap = new HashMap<Long, String>();
        this.oldFormatMetadataFileGenerationMap = new HashMap<String, Tuple<Long, Long>>();
        this.oldFormatMetadataFilePrimaryTermMap = new HashMap<String, Tuple<Long, Long>>();
    }

    @Override
    protected void onDelete() {
        ClusterService.assertClusterOrClusterManagerStateThread();
        try {
            this.trimUnreferencedReaders(true, false);
        }
        catch (IOException e) {
            this.logger.error("Exception while deleting translog files from remote store", (Throwable)e);
        }
    }

    @Override
    protected void onMinRemoteGenReferencedChange() {
        this.triggerTrimOnMinRemoteGenReferencedChange.set(true);
    }

    @Override
    public void trimUnreferencedReaders() throws IOException {
        this.trimUnreferencedReaders(false, true);
    }

    protected void trimUnreferencedReaders(final boolean indexDeleted, boolean trimLocal) throws IOException {
        if (trimLocal) {
            super.trimUnreferencedReaders(true);
        }
        long minLiveGeneration = this.getMinFileGeneration();
        ArrayList<String> staleFilesInTracker = new ArrayList<String>();
        for (String file : this.fileTransferTracker.allUploaded()) {
            long generation;
            if (!file.endsWith(".tlog") || (generation = Translog.parseIdFromFileName(file)) >= minLiveGeneration) continue;
            staleFilesInTracker.add(file);
            staleFilesInTracker.add(Translog.getCommitCheckpointFileName(generation));
        }
        this.fileTransferTracker.delete(staleFilesInTracker);
        if (!(indexDeleted || this.startedPrimarySupplier.getAsBoolean() && !this.pauseSync.get())) {
            return;
        }
        if (!indexDeleted && RemoteStoreUtils.isPinnedTimestampStateStale()) {
            this.logger.debug("Skipping remote translog garbage collection as last fetch of pinned timestamp is stale");
            return;
        }
        if (!indexDeleted && !this.triggerTrimOnMinRemoteGenReferencedChange.get()) {
            return;
        }
        if (this.triggerTrimOnMinRemoteGenReferencedChange.get()) {
            this.triggerTrimOnMinRemoteGenReferencedChange.set(false);
        }
        if (!this.remoteGenerationDeletionPermits.tryAcquire(2)) {
            return;
        }
        ActionListener<List<BlobMetadata>> listMetadataFilesListener = new ActionListener<List<BlobMetadata>>(this){
            final /* synthetic */ RemoteFsTimestampAwareTranslog this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(List<BlobMetadata> blobMetadata) {
                block15: {
                    List<String> metadataFiles = blobMetadata.stream().map(BlobMetadata::name).collect(Collectors.toList());
                    try {
                        if (!indexDeleted && metadataFiles.size() <= 1) {
                            this.this$0.logger.debug("No stale translog metadata files found");
                            this.this$0.remoteGenerationDeletionPermits.release(2);
                            return;
                        }
                        if (!indexDeleted && RemoteStoreUtils.isPinnedTimestampStateStale()) {
                            this.this$0.logger.debug("Skipping remote translog garbage collection as last fetch of pinned timestamp is stale");
                            this.this$0.remoteGenerationDeletionPermits.release(2);
                            return;
                        }
                        List<String> metadataFilesToBeDeleted = this.this$0.getMetadataFilesToBeDeleted(metadataFiles, indexDeleted);
                        if (!indexDeleted) {
                            metadataFilesToBeDeleted.remove(metadataFiles.get(0));
                        }
                        if (metadataFilesToBeDeleted.isEmpty()) {
                            this.this$0.logger.debug("No metadata files to delete");
                            this.this$0.remoteGenerationDeletionPermits.release(2);
                            return;
                        }
                        this.this$0.logger.debug(() -> "metadataFilesToBeDeleted = " + String.valueOf(metadataFilesToBeDeleted));
                        ArrayList<String> metadataFilesNotToBeDeleted = new ArrayList<String>(metadataFiles);
                        metadataFilesNotToBeDeleted.removeAll(metadataFilesToBeDeleted);
                        this.this$0.logger.debug(() -> "metadataFilesNotToBeDeleted = " + String.valueOf(metadataFilesNotToBeDeleted));
                        Set<Long> generationsToBeDeleted = this.this$0.getGenerationsToBeDeleted(metadataFilesNotToBeDeleted, metadataFilesToBeDeleted, indexDeleted ? Long.MAX_VALUE : this.this$0.getMinGenerationToKeepInRemote());
                        this.this$0.logger.debug(() -> "generationsToBeDeleted = " + String.valueOf(generationsToBeDeleted));
                        if (!generationsToBeDeleted.isEmpty()) {
                            try {
                                this.this$0.translogTransferManager.deleteGenerationAsync(this.this$0.primaryTermSupplier.getAsLong(), generationsToBeDeleted, this.this$0.remoteGenerationDeletionPermits::release);
                            }
                            catch (Exception e) {
                                this.this$0.logger.error("Exception in delete generations flow", (Throwable)e);
                                this.this$0.remoteGenerationDeletionPermits.release();
                                assert (this.this$0.remoteGenerationDeletionPermits.availablePermits() == 2) : "Available permits " + this.this$0.remoteGenerationDeletionPermits.availablePermits() + " is not equal to 2";
                                return;
                            }
                        } else {
                            this.this$0.remoteGenerationDeletionPermits.release();
                        }
                        if (!metadataFilesToBeDeleted.isEmpty()) {
                            try {
                                this.this$0.translogTransferManager.deleteMetadataFilesAsync(metadataFilesToBeDeleted, this.this$0.remoteGenerationDeletionPermits::release);
                            }
                            catch (Exception e) {
                                this.this$0.logger.error("Exception in delete metadata files flow", (Throwable)e);
                                assert (this.this$0.remoteGenerationDeletionPermits.availablePermits() == 2) : "Available permits " + this.this$0.remoteGenerationDeletionPermits.availablePermits() + " is not equal to 2";
                                return;
                            }
                            this.this$0.oldFormatMetadataFileGenerationMap.keySet().retainAll(metadataFilesNotToBeDeleted);
                            this.this$0.oldFormatMetadataFilePrimaryTermMap.keySet().retainAll(metadataFilesNotToBeDeleted);
                            this.this$0.deleteStaleRemotePrimaryTerms(metadataFilesNotToBeDeleted);
                            break block15;
                        }
                        this.this$0.remoteGenerationDeletionPermits.release();
                    }
                    catch (Exception e) {
                        this.this$0.logger.error("Exception in trimUnreferencedReaders", (Throwable)e);
                        this.this$0.remoteGenerationDeletionPermits.release(2);
                        if ($assertionsDisabled || this.this$0.remoteGenerationDeletionPermits.availablePermits() == 2) break block15;
                        throw new AssertionError((Object)("Available permits " + this.this$0.remoteGenerationDeletionPermits.availablePermits() + " is not equal to 2"));
                    }
                }
            }

            public void onFailure(Exception e) {
                this.this$0.remoteGenerationDeletionPermits.release(2);
                this.this$0.logger.error("Exception while listing translog metadata files", (Throwable)e);
            }
        };
        this.translogTransferManager.listTranslogMetadataFilesAsync(listMetadataFilesListener);
    }

    private long getMinGenerationToKeepInRemote() {
        return this.minRemoteGenReferenced - (long)this.indexSettings().getRemoteTranslogExtraKeep();
    }

    protected Set<Long> getGenerationsToBeDeleted(List<String> metadataFilesNotToBeDeleted, List<String> metadataFilesToBeDeleted, long minGenerationToKeepInRemote) throws IOException {
        HashSet generationsFromMetadataFilesToBeDeleted = new HashSet();
        for (String mdFile : metadataFilesToBeDeleted) {
            Tuple<Long, Long> minMaxGen = this.getMinMaxTranslogGenerationFromMetadataFile(mdFile, this.translogTransferManager);
            generationsFromMetadataFilesToBeDeleted.addAll(LongStream.rangeClosed((Long)minMaxGen.v1(), (Long)minMaxGen.v2()).boxed().collect(Collectors.toList()));
        }
        Map<String, Tuple<Long, Long>> metadataFileNotToBeDeletedGenerationMap = this.getGenerationForMetadataFiles(metadataFilesNotToBeDeleted);
        TreeSet<Tuple<Long, Long>> pinnedGenerations = this.getOrderedPinnedMetadataGenerations(metadataFileNotToBeDeletedGenerationMap);
        HashSet<Long> generationsToBeDeleted = new HashSet<Long>();
        Iterator iterator = generationsFromMetadataFilesToBeDeleted.iterator();
        while (iterator.hasNext()) {
            long generation = (Long)iterator.next();
            if (generation >= minGenerationToKeepInRemote || this.isGenerationPinned(generation, pinnedGenerations)) continue;
            generationsToBeDeleted.add(generation);
        }
        return generationsToBeDeleted;
    }

    protected List<String> getMetadataFilesToBeDeleted(List<String> metadataFiles, boolean indexDeleted) {
        return RemoteFsTimestampAwareTranslog.getMetadataFilesToBeDeleted(metadataFiles, this.metadataFilePinnedTimestampMap, this.getMinGenerationToKeepInRemote(), indexDeleted, this.logger);
    }

    protected static List<String> getMetadataFilesToBeDeleted(List<String> metadataFiles, Map<Long, String> metadataFilePinnedTimestampMap, long minGenerationToKeepInRemote, boolean indexDeleted, Logger logger) {
        Tuple<Long, Set<Long>> pinnedTimestampsState = RemoteStorePinnedTimestampService.getPinnedTimestamps();
        List<String> metadataFilesToBeDeleted = RemoteStoreUtils.filterOutMetadataFilesBasedOnAge(metadataFiles, file -> RemoteStoreUtils.invertLong(file.split("__")[3]), (Long)pinnedTimestampsState.v1());
        logger.trace("metadataFiles.size = {}, metadataFilesToBeDeleted based on age based filtering = {}", (Object)metadataFiles.size(), (Object)metadataFilesToBeDeleted.size());
        HashSet<Long> pinnedTimestamps = new HashSet<Long>((Collection)pinnedTimestampsState.v2());
        pinnedTimestamps.add((Long)pinnedTimestampsState.v1());
        Set<String> implicitLockedFiles = RemoteStoreUtils.getPinnedTimestampLockedFiles(metadataFilesToBeDeleted, pinnedTimestamps, metadataFilePinnedTimestampMap, file -> RemoteStoreUtils.invertLong(file.split("__")[3]), TranslogTransferMetadata::getNodeIdByPrimaryTermAndGen);
        metadataFilesToBeDeleted.removeAll(implicitLockedFiles);
        logger.trace("implicitLockedFiles.size = {}, metadataFilesToBeDeleted based on pinned timestamp filtering = {}", (Object)implicitLockedFiles.size(), (Object)metadataFilesToBeDeleted.size());
        if (!indexDeleted) {
            List metadataFilesContainingMinGenerationToKeep = metadataFilesToBeDeleted.stream().filter(md -> {
                long maxGeneration = TranslogTransferMetadata.getMaxGenerationFromFileName(md);
                return maxGeneration == -1L || maxGeneration >= minGenerationToKeepInRemote;
            }).collect(Collectors.toList());
            metadataFilesToBeDeleted.removeAll(metadataFilesContainingMinGenerationToKeep);
            logger.trace("metadataFilesContainingMinGenerationToKeep.size = {}, metadataFilesToBeDeleted based on minGenerationToKeep filtering = {}, minGenerationToKeep = {}", (Object)metadataFilesContainingMinGenerationToKeep.size(), (Object)metadataFilesToBeDeleted.size(), (Object)minGenerationToKeepInRemote);
        }
        return metadataFilesToBeDeleted;
    }

    protected boolean isGenerationPinned(long generation, TreeSet<Tuple<Long, Long>> pinnedGenerations) {
        Tuple<Long, Long> ceilingGenerationRange = pinnedGenerations.ceiling((Tuple<Long, Long>)new Tuple((Object)generation, (Object)generation));
        if (ceilingGenerationRange != null && generation >= (Long)ceilingGenerationRange.v1() && generation <= (Long)ceilingGenerationRange.v2()) {
            return true;
        }
        Tuple<Long, Long> floorGenerationRange = pinnedGenerations.floor((Tuple<Long, Long>)new Tuple((Object)generation, (Object)generation));
        return floorGenerationRange != null && generation >= (Long)floorGenerationRange.v1() && generation <= (Long)floorGenerationRange.v2();
    }

    private TreeSet<Tuple<Long, Long>> getOrderedPinnedMetadataGenerations(Map<String, Tuple<Long, Long>> metadataFileGenerationMap) {
        TreeSet<Tuple<Long, Long>> pinnedGenerations = new TreeSet<Tuple<Long, Long>>((o1, o2) -> {
            if (!Objects.equals(o1.v1(), o2.v1())) {
                return ((Long)o1.v1()).compareTo((Long)o2.v1());
            }
            return ((Long)o1.v2()).compareTo((Long)o2.v2());
        });
        pinnedGenerations.addAll(metadataFileGenerationMap.values());
        return pinnedGenerations;
    }

    protected Map<String, Tuple<Long, Long>> getGenerationForMetadataFiles(List<String> metadataFiles) throws IOException {
        HashMap<String, Tuple<Long, Long>> metadataFileGenerationMap = new HashMap<String, Tuple<Long, Long>>();
        for (String metadataFile : metadataFiles) {
            metadataFileGenerationMap.put(metadataFile, this.getMinMaxTranslogGenerationFromMetadataFile(metadataFile, this.translogTransferManager));
        }
        return metadataFileGenerationMap;
    }

    protected Tuple<Long, Long> getMinMaxTranslogGenerationFromMetadataFile(String metadataFile, TranslogTransferManager translogTransferManager) throws IOException {
        Tuple<Long, Long> minMaxGenerationFromFileName = TranslogTransferMetadata.getMinMaxTranslogGenerationFromFilename(metadataFile);
        if (minMaxGenerationFromFileName != null) {
            return minMaxGenerationFromFileName;
        }
        if (this.oldFormatMetadataFileGenerationMap.containsKey(metadataFile)) {
            return this.oldFormatMetadataFileGenerationMap.get(metadataFile);
        }
        TranslogTransferMetadata metadata = translogTransferManager.readMetadata(metadataFile);
        Tuple minMaxGenTuple = new Tuple((Object)metadata.getMinTranslogGeneration(), (Object)metadata.getGeneration());
        this.oldFormatMetadataFileGenerationMap.put(metadataFile, (Tuple<Long, Long>)minMaxGenTuple);
        return minMaxGenTuple;
    }

    private void deleteStaleRemotePrimaryTerms(List<String> metadataFilesNotToBeDeleted) {
        RemoteFsTimestampAwareTranslog.deleteStaleRemotePrimaryTerms(metadataFilesNotToBeDeleted, this.translogTransferManager, this.oldFormatMetadataFilePrimaryTermMap, this.minPrimaryTermInRemote, this.logger);
    }

    protected static void deleteStaleRemotePrimaryTerms(List<String> metadataFilesNotToBeDeleted, TranslogTransferManager translogTransferManager, Map<String, Tuple<Long, Long>> oldFormatMetadataFilePrimaryTermMap, AtomicLong minPrimaryTermInRemoteAtomicLong, Logger logger) {
        if (metadataFilesNotToBeDeleted.isEmpty()) {
            logger.trace("No metadata is uploaded yet, returning from deleteStaleRemotePrimaryTerms");
            return;
        }
        Optional<Long> minPrimaryTermFromMetadataFiles = metadataFilesNotToBeDeleted.stream().map(file -> {
            try {
                return (Long)RemoteFsTimestampAwareTranslog.getMinMaxPrimaryTermFromMetadataFile(file, translogTransferManager, oldFormatMetadataFilePrimaryTermMap, logger).v1();
            }
            catch (IOException e) {
                return Long.MIN_VALUE;
            }
        }).min(Long::compareTo);
        Long minPrimaryTermInRemote = RemoteFsTimestampAwareTranslog.getMinPrimaryTermInRemote(minPrimaryTermInRemoteAtomicLong, translogTransferManager, logger);
        if (minPrimaryTermFromMetadataFiles.get() > minPrimaryTermInRemote) {
            translogTransferManager.deletePrimaryTermsAsync(minPrimaryTermFromMetadataFiles.get());
            minPrimaryTermInRemoteAtomicLong.set(minPrimaryTermFromMetadataFiles.get());
        } else {
            logger.debug("Skipping primary term cleanup. minimumReferencedPrimaryTerm = {}, minPrimaryTermInRemote = {}", (Object)minPrimaryTermFromMetadataFiles.get(), (Object)minPrimaryTermInRemote);
        }
    }

    protected static Long getMinPrimaryTermInRemote(AtomicLong minPrimaryTermInRemote, TranslogTransferManager translogTransferManager, Logger logger) {
        if (minPrimaryTermInRemote.get() == Long.MAX_VALUE) {
            try {
                Set<Long> primaryTermsInRemote = translogTransferManager.listPrimaryTermsInRemote();
                if (!primaryTermsInRemote.isEmpty()) {
                    Optional minPrimaryTerm = primaryTermsInRemote.stream().min(Long::compareTo);
                    minPrimaryTerm.ifPresent(minPrimaryTermInRemote::set);
                }
            }
            catch (IOException e) {
                logger.error("Exception while listing primary terms in remote translog", (Throwable)e);
            }
        }
        return minPrimaryTermInRemote.get();
    }

    protected static Tuple<Long, Long> getMinMaxPrimaryTermFromMetadataFile(String metadataFile, TranslogTransferManager translogTransferManager, Map<String, Tuple<Long, Long>> oldFormatMetadataFilePrimaryTermMap, Logger logger) throws IOException {
        Tuple<Long, Long> minMaxPrimaryTermFromFileName = TranslogTransferMetadata.getMinMaxPrimaryTermFromFilename(metadataFile);
        if (minMaxPrimaryTermFromFileName != null) {
            return minMaxPrimaryTermFromFileName;
        }
        if (oldFormatMetadataFilePrimaryTermMap.containsKey(metadataFile)) {
            return oldFormatMetadataFilePrimaryTermMap.get(metadataFile);
        }
        TranslogTransferMetadata metadata = translogTransferManager.readMetadata(metadataFile);
        long maxPrimaryTem = TranslogTransferMetadata.getPrimaryTermFromFileName(metadataFile);
        long minPrimaryTem = -1L;
        if (metadata.getGenerationToPrimaryTermMapper() != null && !metadata.getGenerationToPrimaryTermMapper().values().isEmpty()) {
            Optional<Long> primaryTerm = metadata.getGenerationToPrimaryTermMapper().values().stream().map(s -> Long.parseLong(s)).min(Long::compareTo);
            if (primaryTerm.isPresent()) {
                minPrimaryTem = primaryTerm.get();
            }
        } else {
            logger.warn("No primary term found from GenerationToPrimaryTermMap for file [{}]", (Object)metadataFile);
        }
        Tuple minMaxPrimaryTermTuple = new Tuple((Object)minPrimaryTem, (Object)maxPrimaryTem);
        oldFormatMetadataFilePrimaryTermMap.put(metadataFile, (Tuple<Long, Long>)minMaxPrimaryTermTuple);
        return minMaxPrimaryTermTuple;
    }

    public static void cleanupOfDeletedIndex(final TranslogTransferManager translogTransferManager, boolean forceClean) throws IOException {
        if (forceClean) {
            translogTransferManager.delete();
        } else {
            ActionListener<List<BlobMetadata>> listMetadataFilesListener = new ActionListener<List<BlobMetadata>>(){

                public void onResponse(List<BlobMetadata> blobMetadata) {
                    List<String> metadataFiles = blobMetadata.stream().map(BlobMetadata::name).collect(Collectors.toList());
                    try {
                        if (metadataFiles.isEmpty()) {
                            staticLogger.debug("No stale translog metadata files found");
                            return;
                        }
                        List<String> metadataFilesToBeDeleted = RemoteFsTimestampAwareTranslog.getMetadataFilesToBeDeleted(metadataFiles, new HashMap<Long, String>(), Long.MAX_VALUE, true, staticLogger);
                        if (metadataFilesToBeDeleted.isEmpty()) {
                            staticLogger.debug("No metadata files to delete");
                            return;
                        }
                        staticLogger.debug(() -> "metadataFilesToBeDeleted = " + String.valueOf(metadataFilesToBeDeleted));
                        ArrayList<String> metadataFilesNotToBeDeleted = new ArrayList<String>(metadataFiles);
                        metadataFilesNotToBeDeleted.removeAll(metadataFilesToBeDeleted);
                        staticLogger.debug(() -> "metadataFilesNotToBeDeleted = " + String.valueOf(metadataFilesNotToBeDeleted));
                        translogTransferManager.deleteMetadataFilesAsync(metadataFilesToBeDeleted, () -> {});
                        RemoteFsTimestampAwareTranslog.deleteStaleRemotePrimaryTerms(metadataFilesNotToBeDeleted, translogTransferManager, new HashMap<String, Tuple<Long, Long>>(), new AtomicLong(Long.MAX_VALUE), staticLogger);
                    }
                    catch (Exception e) {
                        staticLogger.error("Exception while cleaning up metadata and primary terms", (Throwable)e);
                    }
                }

                public void onFailure(Exception e) {
                    staticLogger.error("Exception while cleaning up metadata and primary terms", (Throwable)e);
                }
            };
            translogTransferManager.listTranslogMetadataFilesAsync(listMetadataFilesListener);
        }
    }
}

