/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import shaded.com.google.common.collect.ImmutableList;

public class ExtendedRexBuilder
extends RexBuilder {
    public ExtendedRexBuilder(RexBuilder rexBuilder) {
        super(rexBuilder.getTypeFactory());
    }

    public RexNode coalesce(RexNode ... nodes) {
        return this.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, nodes);
    }

    public RexNode equals(RexNode n1, RexNode n2) {
        return this.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{n1, n2});
    }

    public RexNode and(RexNode left, RexNode right) {
        RelDataType booleanType = this.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
        return this.makeCall(booleanType, (SqlOperator)SqlStdOperatorTable.AND, List.of(left, right));
    }

    public RelDataType commonType(RexNode ... nodes) {
        return this.getTypeFactory().leastRestrictive(Arrays.stream(nodes).map(RexNode::getType).toList());
    }

    public SqlIntervalQualifier createIntervalUntil(SpanUnit unit) {
        TimeUnit timeUnit = switch (unit) {
            case SpanUnit.MILLISECOND, SpanUnit.MS -> TimeUnit.MILLISECOND;
            case SpanUnit.SECOND, SpanUnit.S -> TimeUnit.SECOND;
            case SpanUnit.MINUTE, SpanUnit.m -> TimeUnit.MINUTE;
            case SpanUnit.HOUR, SpanUnit.H -> TimeUnit.HOUR;
            case SpanUnit.DAY, SpanUnit.D -> TimeUnit.DAY;
            case SpanUnit.WEEK, SpanUnit.W -> TimeUnit.WEEK;
            case SpanUnit.MONTH, SpanUnit.M -> TimeUnit.MONTH;
            case SpanUnit.QUARTER, SpanUnit.Q -> TimeUnit.QUARTER;
            case SpanUnit.YEAR, SpanUnit.Y -> TimeUnit.YEAR;
            default -> TimeUnit.EPOCH;
        };
        return new SqlIntervalQualifier(timeUnit, timeUnit, SqlParserPos.ZERO);
    }

    public RexNode makeCast(SqlParserPos pos, RelDataType type, RexNode exp, boolean matchNullability, boolean safe, RexLiteral format) {
        SqlTypeName sqlType = type.getSqlTypeName();
        RelDataType sourceType = exp.getType();
        if (exp instanceof RexLiteral && sqlType == SqlTypeName.BOOLEAN) {
            if (exp.equals((Object)this.makeLiteral("1", this.typeFactory.createSqlType(SqlTypeName.CHAR, 1)))) {
                return this.makeLiteral(true, type);
            }
            if (exp.equals((Object)this.makeLiteral("0", this.typeFactory.createSqlType(SqlTypeName.CHAR, 1)))) {
                return this.makeLiteral(false, type);
            }
            if (SqlTypeUtil.isExactNumeric((RelDataType)sourceType)) {
                return this.makeCall(type, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (List)ImmutableList.of((Object)exp, (Object)this.makeZeroLiteral(sourceType)));
            }
        } else {
            if (OpenSearchTypeFactory.isUserDefinedType(type)) {
                OpenSearchTypeFactory.ExprUDT udt = ((AbstractExprRelDataType)type).getUdt();
                ExprType argExprType = OpenSearchTypeFactory.convertRelDataTypeToExprType(sourceType);
                return switch (udt) {
                    case OpenSearchTypeFactory.ExprUDT.EXPR_DATE -> this.makeCall(type, PPLBuiltinOperators.DATE, List.of(exp));
                    case OpenSearchTypeFactory.ExprUDT.EXPR_TIME -> this.makeCall(type, PPLBuiltinOperators.TIME, List.of(exp));
                    case OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP -> this.makeCall(type, PPLBuiltinOperators.TIMESTAMP, List.of(exp));
                    case OpenSearchTypeFactory.ExprUDT.EXPR_IP -> {
                        if (argExprType == ExprCoreType.IP) {
                            yield exp;
                        }
                        if (argExprType == ExprCoreType.STRING) {
                            yield this.makeCall(type, PPLBuiltinOperators.IP, List.of(exp));
                        }
                        throw new ExpressionEvaluationException(String.format(Locale.ROOT, "Cannot convert %s to IP, only STRING and IP types are supported", argExprType));
                    }
                    default -> throw new SemanticCheckException(String.format(Locale.ROOT, "Cannot cast from %s to %s", argExprType, udt.name()));
                };
            }
            if ((SqlTypeUtil.isApproximateNumeric((RelDataType)sourceType) || SqlTypeUtil.isDecimal((RelDataType)sourceType)) && SqlTypeUtil.isCharacter((RelDataType)type)) {
                return this.makeCall(type, PPLBuiltinOperators.NUMBER_TO_STRING, List.of(exp));
            }
        }
        return super.makeCast(pos, type, exp, matchNullability, safe, format);
    }
}

