/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class MonthSpanHandler {
    public RexNode createExpression(RexNode fieldExpr, int intervalMonths, CalcitePlanContext context) {
        RexNode inputYear = context.rexBuilder.makeCall(PPLBuiltinOperators.YEAR, new RexNode[]{fieldExpr});
        RexNode inputMonth = context.rexBuilder.makeCall(PPLBuiltinOperators.MONTH, new RexNode[]{fieldExpr});
        RexNode monthsSinceEpoch = this.calculateMonthsSinceEpoch(inputYear, inputMonth, context);
        RexNode binStartMonths = this.calculateBinStart(monthsSinceEpoch, intervalMonths, context);
        RexNode binStartYear = this.calculateBinStartYear(binStartMonths, context);
        RexNode binStartMonth = this.calculateBinStartMonth(binStartMonths, context);
        RexNode tempDate = context.rexBuilder.makeCall(PPLBuiltinOperators.MAKEDATE, new RexNode[]{binStartYear, context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{binStartMonth, context.relBuilder.literal((Object)1)}), context.relBuilder.literal((Object)31)}), context.relBuilder.literal((Object)1)})});
        return context.rexBuilder.makeCall(PPLBuiltinOperators.DATE_FORMAT, new RexNode[]{tempDate, context.relBuilder.literal((Object)"%Y-%m")});
    }

    private RexNode calculateMonthsSinceEpoch(RexNode inputYear, RexNode inputMonth, CalcitePlanContext context) {
        RexNode yearsSinceEpoch = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{inputYear, context.relBuilder.literal((Object)1970)});
        RexNode monthsFromYears = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{yearsSinceEpoch, context.relBuilder.literal((Object)12)});
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{monthsFromYears, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{inputMonth, context.relBuilder.literal((Object)1)})});
    }

    private RexNode calculateBinStart(RexNode value, int interval, CalcitePlanContext context) {
        RexLiteral intervalLiteral = context.relBuilder.literal((Object)interval);
        RexNode positionInCycle = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, new RexNode[]{value, intervalLiteral});
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{value, positionInCycle});
    }

    private RexNode calculateBinStartYear(RexNode binStartMonths, CalcitePlanContext context) {
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{context.relBuilder.literal((Object)1970), context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{binStartMonths, context.relBuilder.literal((Object)12)})});
    }

    private RexNode calculateBinStartMonth(RexNode binStartMonths, CalcitePlanContext context) {
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, new RexNode[]{binStartMonths, context.relBuilder.literal((Object)12)}), context.relBuilder.literal((Object)1)});
    }
}

