/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public final class RexExtractFunction
extends ImplementorUDF {
    public RexExtractFunction() {
        super(new RexExtractImplementor(), NullPolicy.ARG0);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR_2000_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.STRING_STRING_INTEGER;
    }

    public static String extractGroup(String text, String pattern, int groupIndex) {
        try {
            Pattern compiledPattern = Pattern.compile(pattern);
            Matcher matcher = compiledPattern.matcher(text);
            if (matcher.find() && groupIndex > 0 && groupIndex <= matcher.groupCount()) {
                return matcher.group(groupIndex);
            }
            return null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Error in 'rex' command: Encountered the following error while compiling the regex '" + pattern + "': " + e.getMessage());
        }
    }

    private static class RexExtractImplementor
    implements NotNullImplementor {
        private RexExtractImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression field = translatedOperands.get(0);
            Expression pattern = translatedOperands.get(1);
            Expression groupIndex = translatedOperands.get(2);
            return Expressions.call(RexExtractFunction.class, (String)"extractGroup", (Expression[])new Expression[]{field, pattern, groupIndex});
        }
    }
}

