/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.request.AggregateFilterAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.ArgMaxMinParser;
import org.opensearch.sql.opensearch.response.agg.BucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.CompositeAggregationParser;
import org.opensearch.sql.opensearch.response.agg.CountAsTotalHitsParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.NoBucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.response.agg.SinglePercentileParser;
import org.opensearch.sql.opensearch.response.agg.SingleValueParser;
import org.opensearch.sql.opensearch.response.agg.StatsParser;
import org.opensearch.sql.opensearch.response.agg.TopHitsParser;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.BucketAggregationBuilder;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.CompositeAggregationBuilder;
import shaded.com.google.common.base.Throwables;
import shaded.com.google.common.collect.ImmutableList;

public class AggregateAnalyzer {
    public static final int AGGREGATION_BUCKET_SIZE = 1000;
    private static final String METADATA_FIELD = "_index";

    private AggregateAnalyzer() {
    }

    public static Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> analyze(Aggregate aggregate, Project project, RelDataType rowType, Map<String, ExprType> fieldTypes, List<String> outputFields, RelOptCluster cluster) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(aggregate, "aggregate");
        try {
            boolean allCountAggRemoved;
            boolean bucketNullable = Boolean.parseBoolean(aggregate.getHints().stream().filter(hits -> hits.hintName.equals("stats_args")).map(hint -> hint.kvOptions.getOrDefault("bucket_nullable", "true")).findFirst().orElseGet(() -> "true"));
            List groupList = aggregate.getGroupSet().asList();
            AggregateBuilderHelper helper = new AggregateBuilderHelper(rowType, fieldTypes, cluster, bucketNullable);
            List<String> aggFieldNames = outputFields.subList(groupList.size(), outputFields.size());
            Pair<AggregatorFactories.Builder, List<MetricParser>> builderAndParser = AggregateAnalyzer.processAggregateCalls(aggFieldNames, aggregate.getAggCallList(), project, helper);
            AggregatorFactories.Builder metricBuilder = (AggregatorFactories.Builder)builderAndParser.getLeft();
            List metricParserList = (List)builderAndParser.getRight();
            boolean countAllOnly = !aggregate.getGroupSet().isEmpty();
            Pair<List<ValueCountAggregationBuilder>, AggregatorFactories.Builder> pair = AggregateAnalyzer.removeCountAggregationBuilders(metricBuilder, countAllOnly);
            List removedCountAggBuilders = (List)pair.getLeft();
            AggregatorFactories.Builder newMetricBuilder = (AggregatorFactories.Builder)pair.getRight();
            boolean removedCountAggBuildersHaveSomeField = removedCountAggBuilders.stream().map(ValuesSourceAggregationBuilder::fieldName).distinct().count() == 1L;
            boolean bl = allCountAggRemoved = removedCountAggBuilders.size() == metricBuilder.getAggregatorFactories().size();
            if (aggregate.getGroupSet().isEmpty()) {
                if (allCountAggRemoved && removedCountAggBuildersHaveSomeField) {
                    List<String> countAggNameList = removedCountAggBuilders.stream().map(AggregationBuilder::getName).toList();
                    return Pair.of((Object)ImmutableList.copyOf((Collection)newMetricBuilder.getAggregatorFactories()), (Object)new CountAsTotalHitsParser(countAggNameList));
                }
                return Pair.of((Object)ImmutableList.copyOf((Collection)metricBuilder.getAggregatorFactories()), (Object)new NoBucketAggregationParser(metricParserList));
            }
            if (aggregate.getGroupSet().length() == 1 && AggregateAnalyzer.isAutoDateSpan((RexNode)project.getProjects().get((Integer)groupList.getFirst()))) {
                RexCall rexCall = (RexCall)project.getProjects().get((Integer)groupList.getFirst());
                String bucketName = ((RelDataTypeField)project.getRowType().getFieldList().get((Integer)groupList.getFirst())).getName();
                RexInputRef rexInputRef = (RexInputRef)rexCall.getOperands().getFirst();
                RexLiteral valueLiteral = (RexLiteral)rexCall.getOperands().get(1);
                AutoDateHistogramAggregationBuilder bucketBuilder = ((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder(bucketName).field(helper.inferNamedField((RexNode)rexInputRef).getRootName())).setNumBuckets(Objects.requireNonNull((Integer)valueLiteral.getValueAs(Integer.class)).intValue());
                return Pair.of(Collections.singletonList(bucketBuilder.subAggregations(metricBuilder)), (Object)new BucketAggregationParser(metricParserList));
            }
            List<CompositeValuesSourceBuilder<?>> buckets = AggregateAnalyzer.createCompositeBuckets(groupList, project, helper);
            org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder aggregationBuilder = AggregationBuilders.composite((String)"composite_buckets", buckets).size(1000);
            if (removedCountAggBuilders.isEmpty() || removedCountAggBuilders.size() != metricBuilder.getAggregatorFactories().size()) {
                aggregationBuilder.subAggregations(metricBuilder);
                return Pair.of(Collections.singletonList(aggregationBuilder), (Object)new CompositeAggregationParser(metricParserList));
            }
            if (!newMetricBuilder.getAggregatorFactories().isEmpty()) {
                aggregationBuilder.subAggregations(newMetricBuilder);
            }
            List<String> countAggNameList = removedCountAggBuilders.stream().map(AggregationBuilder::getName).toList();
            return Pair.of(Collections.singletonList(aggregationBuilder), (Object)new CompositeAggregationParser(metricParserList, countAggNameList));
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, UnsupportedOperationException.class);
            throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(aggregate), e);
        }
    }

    private static Pair<List<ValueCountAggregationBuilder>, AggregatorFactories.Builder> removeCountAggregationBuilders(AggregatorFactories.Builder metricBuilder, boolean countAllOnly) {
        List<ValueCountAggregationBuilder> countAggregatorFactories = metricBuilder.getAggregatorFactories().stream().filter(ValueCountAggregationBuilder.class::isInstance).map(ValueCountAggregationBuilder.class::cast).filter(vc -> vc.script() == null).filter(vc -> !countAllOnly || vc.fieldName().equals(METADATA_FIELD)).toList();
        ArrayList copy = new ArrayList(metricBuilder.getAggregatorFactories());
        copy.removeAll(countAggregatorFactories);
        AggregatorFactories.Builder newMetricBuilder = new AggregatorFactories.Builder();
        copy.forEach(arg_0 -> ((AggregatorFactories.Builder)newMetricBuilder).addAggregator(arg_0));
        return Pair.of(countAggregatorFactories, (Object)newMetricBuilder);
    }

    private static Pair<AggregatorFactories.Builder, List<MetricParser>> processAggregateCalls(List<String> aggFieldNames, List<AggregateCall> aggCalls, Project project, AggregateBuilderHelper helper) throws PredicateAnalyzer.ExpressionNotAnalyzableException {
        AggregatorFactories.Builder metricBuilder = new AggregatorFactories.Builder();
        ArrayList<MetricParser> metricParserList = new ArrayList<MetricParser>();
        AggregateFilterAnalyzer aggFilterAnalyzer = new AggregateFilterAnalyzer(helper, project);
        for (int i = 0; i < aggCalls.size(); ++i) {
            AggregateCall aggCall = aggCalls.get(i);
            List<RexNode> args = AggregateAnalyzer.convertAggArgThroughProject(aggCall, project);
            String aggFieldName = aggFieldNames.get(i);
            Pair<AggregationBuilder, MetricParser> builderAndParser = AggregateAnalyzer.createAggregationBuilderAndParser(aggCall, args, aggFieldName, helper);
            builderAndParser = aggFilterAnalyzer.analyze(builderAndParser, aggCall, aggFieldName);
            metricBuilder.addAggregator((AggregationBuilder)builderAndParser.getLeft());
            metricParserList.add((MetricParser)builderAndParser.getRight());
        }
        return Pair.of((Object)metricBuilder, metricParserList);
    }

    private static List<RexNode> convertAggArgThroughProject(AggregateCall aggCall, Project project) {
        return project == null ? List.of() : aggCall.getArgList().stream().map(project.getProjects()::get).toList();
    }

    private static Pair<AggregationBuilder, MetricParser> createAggregationBuilderAndParser(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        if (aggCall.isDistinct()) {
            return AggregateAnalyzer.createDistinctAggregation(aggCall, args, aggFieldName, helper);
        }
        return AggregateAnalyzer.createRegularAggregation(aggCall, args, aggFieldName, helper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<AggregationBuilder, MetricParser> createDistinctAggregation(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        switch (aggCall.getAggregation().kind) {
            case COUNT: {
                return Pair.of((Object)helper.build(!args.isEmpty() ? args.getFirst() : null, AggregationBuilders.cardinality((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            }
            default: {
                throw new AggregateAnalyzerException(String.format("unsupported distinct aggregator %s", aggCall.getAggregation()));
            }
        }
    }

    private static Pair<AggregationBuilder, MetricParser> createRegularAggregation(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        return switch (aggCall.getAggregation().kind) {
            case SqlKind.AVG -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.avg((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.SUM -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.sum((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.COUNT -> Pair.of((Object)helper.build(!args.isEmpty() ? args.getFirst() : null, AggregationBuilders.count((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.MIN -> {
                String fieldName = helper.inferNamedField(args.getFirst()).getRootName();
                ExprType fieldType = helper.fieldTypes.get(fieldName);
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.min((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null).size(1).from(0).sort(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery(), SortOrder.ASC), (Object)new TopHitsParser(aggFieldName, true));
            }
            case SqlKind.MAX -> {
                String fieldName = helper.inferNamedField(args.getFirst()).getRootName();
                ExprType fieldType = helper.fieldTypes.get(fieldName);
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.max((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null).size(1).from(0).sort(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery(), SortOrder.DESC), (Object)new TopHitsParser(aggFieldName, true));
            }
            case SqlKind.VAR_SAMP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getVarianceSampling, aggFieldName));
            case SqlKind.VAR_POP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getVariancePopulation, aggFieldName));
            case SqlKind.STDDEV_SAMP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getStdDeviationSampling, aggFieldName));
            case SqlKind.STDDEV_POP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getStdDeviationPopulation, aggFieldName));
            case SqlKind.ARG_MAX -> Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null).size(1).from(0).sort(helper.inferNamedField(args.get(1)).getRootName(), SortOrder.DESC), (Object)new ArgMaxMinParser(aggFieldName));
            case SqlKind.ARG_MIN -> Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null).size(1).from(0).sort(helper.inferNamedField(args.get(1)).getRootName(), SortOrder.ASC), (Object)new ArgMaxMinParser(aggFieldName));
            case SqlKind.OTHER_FUNCTION -> {
                BuiltinFunctionName functionName = BuiltinFunctionName.ofAggregation(aggCall.getAggregation().getName()).get();
                switch (functionName) {
                    case TAKE: {
                        yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null).size(helper.inferValue(args.getLast(), Integer.class).intValue()).from(0), (Object)new TopHitsParser(aggFieldName));
                    }
                    case FIRST: {
                        TopHitsAggregationBuilder firstBuilder = AggregationBuilders.topHits((String)aggFieldName).size(1).from(0);
                        if (!args.isEmpty()) {
                            firstBuilder.fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null);
                        }
                        yield Pair.of((Object)firstBuilder, (Object)new TopHitsParser(aggFieldName, true));
                    }
                    case LAST: {
                        TopHitsAggregationBuilder lastBuilder = AggregationBuilders.topHits((String)aggFieldName).size(1).from(0).sort("_doc", SortOrder.DESC);
                        if (!args.isEmpty()) {
                            lastBuilder.fetchSource(helper.inferNamedField(args.getFirst()).getRootName(), null);
                        }
                        yield Pair.of((Object)lastBuilder, (Object)new TopHitsParser(aggFieldName, true));
                    }
                    case PERCENTILE_APPROX: {
                        PercentilesAggregationBuilder aggBuilder = helper.build(args.getFirst(), AggregationBuilders.percentiles((String)aggFieldName)).percentiles(new double[]{helper.inferValue(args.get(1), Double.class)});
                        if (args.size() > 3) {
                            aggBuilder.compression(helper.inferValue(args.getLast(), Double.class).doubleValue());
                        }
                        yield Pair.of((Object)aggBuilder, (Object)new SinglePercentileParser(aggFieldName));
                    }
                }
                throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s", aggCall.getAggregation()));
            }
            default -> throw new AggregateAnalyzerException(String.format("unsupported aggregator %s", aggCall.getAggregation()));
        };
    }

    private static boolean supportsMaxMinAggregation(ExprType fieldType) {
        ExprType coreType = fieldType instanceof OpenSearchDataType ? ((OpenSearchDataType)fieldType).getExprType() : fieldType;
        return ExprCoreType.numberTypes().contains(coreType) || coreType == ExprCoreType.DATE || coreType == ExprCoreType.TIME || coreType == ExprCoreType.TIMESTAMP;
    }

    private static ValuesSourceAggregationBuilder<?> createBucketAggregation(Integer group, Project project, AggregateBuilderHelper helper) {
        return AggregateAnalyzer.createBucket(group, project, helper);
    }

    private static List<CompositeValuesSourceBuilder<?>> createCompositeBuckets(List<Integer> groupList, Project project, AggregateBuilderHelper helper) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        groupList.forEach(groupIndex -> resultBuilder.add(AggregateAnalyzer.createCompositeBucket(groupIndex, project, helper)));
        return resultBuilder.build();
    }

    private static boolean isAutoDateSpan(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().equals((Object)PPLBuiltinOperators.WIDTH_BUCKET);
    }

    private static ValuesSourceAggregationBuilder<?> createBucket(Integer groupIndex, Project project, AggregateBuilderHelper helper) {
        Object e;
        RexCall rexCall;
        RexNode rex = (RexNode)project.getProjects().get(groupIndex);
        String bucketName = ((RelDataTypeField)project.getRowType().getFieldList().get(groupIndex)).getName();
        if (rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().getName().equalsIgnoreCase(BuiltinFunctionName.SPAN.name()) && rexCall.getOperands().size() == 3 && (e = rexCall.getOperands().getFirst()) instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)e;
            e = rexCall.getOperands().get(1);
            if (e instanceof RexLiteral) {
                RexLiteral valueLiteral = (RexLiteral)e;
                e = rexCall.getOperands().get(2);
                if (e instanceof RexLiteral) {
                    RexLiteral unitLiteral = (RexLiteral)e;
                    return BucketAggregationBuilder.buildHistogram(bucketName, helper.inferNamedField((RexNode)rexInputRef).getRootName(), (Double)valueLiteral.getValueAs(Double.class), SpanUnit.of((String)unitLiteral.getValueAs(String.class)));
                }
            }
        }
        return AggregateAnalyzer.createTermsAggregationBuilder(bucketName, rex, helper);
    }

    private static CompositeValuesSourceBuilder<?> createCompositeBucket(Integer groupIndex, Project project, AggregateBuilderHelper helper) {
        Object e;
        RexCall rexCall;
        RexNode rex = (RexNode)project.getProjects().get(groupIndex);
        String bucketName = ((RelDataTypeField)project.getRowType().getFieldList().get(groupIndex)).getName();
        if (rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().getName().equalsIgnoreCase(BuiltinFunctionName.SPAN.name()) && rexCall.getOperands().size() == 3 && (e = rexCall.getOperands().getFirst()) instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)e;
            e = rexCall.getOperands().get(1);
            if (e instanceof RexLiteral) {
                RexLiteral valueLiteral = (RexLiteral)e;
                e = rexCall.getOperands().get(2);
                if (e instanceof RexLiteral) {
                    RexLiteral unitLiteral = (RexLiteral)e;
                    return CompositeAggregationBuilder.buildHistogram(bucketName, helper.inferNamedField((RexNode)rexInputRef).getRootName(), (Double)valueLiteral.getValueAs(Double.class), SpanUnit.of((String)unitLiteral.getValueAs(String.class)), MissingOrder.FIRST, helper.bucketNullable);
                }
            }
        }
        if (AggregateAnalyzer.isAutoDateSpan(rex)) {
            throw new UnsupportedOperationException("auto_date_histogram is not supported in composite agg.");
        }
        return AggregateAnalyzer.createTermsSourceBuilder(bucketName, rex, helper);
    }

    private static CompositeValuesSourceBuilder<?> createTermsSourceBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsValuesSourceBuilder termsBuilder = (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(bucketName).order(SortOrder.ASC);
        if (helper.bucketNullable) {
            ((TermsValuesSourceBuilder)termsBuilder.missingBucket(true)).missingOrder(MissingOrder.FIRST);
        }
        TermsValuesSourceBuilder sourceBuilder = helper.build(group, termsBuilder);
        if (List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(OpenSearchTypeFactory.convertRelDataTypeToExprType(group.getType()))) {
            sourceBuilder.userValuetypeHint(ValueType.LONG);
        }
        return sourceBuilder;
    }

    private static ValuesSourceAggregationBuilder<?> createTermsAggregationBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsAggregationBuilder sourceBuilder = helper.build(group, new TermsAggregationBuilder(bucketName).size(1000).order(BucketOrder.key((boolean)true)));
        if (List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(OpenSearchTypeFactory.convertRelDataTypeToExprType(group.getType()))) {
            sourceBuilder.userValueTypeHint(ValueType.LONG);
        }
        return sourceBuilder;
    }

    static class AggregateBuilderHelper {
        final RelDataType rowType;
        final Map<String, ExprType> fieldTypes;
        final RelOptCluster cluster;
        final boolean bucketNullable;

        <T extends ValuesSourceAggregationBuilder<T>> T build(RexNode node, T aggBuilder) {
            return (T)this.build(node, arg_0 -> aggBuilder.field(arg_0), arg_0 -> aggBuilder.script(arg_0));
        }

        <T extends CompositeValuesSourceBuilder<T>> T build(RexNode node, T sourceBuilder) {
            return (T)this.build(node, arg_0 -> sourceBuilder.field(arg_0), arg_0 -> sourceBuilder.script(arg_0));
        }

        <T> T build(RexNode node, Function<String, T> fieldBuilder, Function<Script, T> scriptBuilder) {
            if (node == null) {
                return fieldBuilder.apply(AggregateAnalyzer.METADATA_FIELD);
            }
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return fieldBuilder.apply(new PredicateAnalyzer.NamedFieldExpression(ref.getIndex(), (List<String>)this.rowType.getFieldNames(), this.fieldTypes).getReferenceForTermQuery());
            }
            if (node instanceof RexCall || node instanceof RexLiteral) {
                return scriptBuilder.apply(new PredicateAnalyzer.ScriptQueryExpression(node, this.rowType, this.fieldTypes, this.cluster).getScript());
            }
            throw new IllegalStateException(String.format("Metric aggregation doesn't support RexNode %s", node));
        }

        PredicateAnalyzer.NamedFieldExpression inferNamedField(RexNode node) {
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return new PredicateAnalyzer.NamedFieldExpression(ref.getIndex(), (List<String>)this.rowType.getFieldNames(), this.fieldTypes);
            }
            throw new IllegalStateException(String.format("Cannot infer field name from RexNode %s", node));
        }

        <T> T inferValue(RexNode node, Class<T> clazz) {
            if (node instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)node;
                return (T)literal.getValueAs(clazz);
            }
            throw new IllegalStateException(String.format("Cannot infer value from RexNode %s", node));
        }

        @Generated
        public AggregateBuilderHelper(RelDataType rowType, Map<String, ExprType> fieldTypes, RelOptCluster cluster, boolean bucketNullable) {
            this.rowType = rowType;
            this.fieldTypes = fieldTypes;
            this.cluster = cluster;
            this.bucketNullable = bucketNullable;
        }
    }

    public static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class AggregateAnalyzerException
    extends RuntimeException {
        AggregateAnalyzerException(String message) {
            super(message);
        }

        AggregateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }
}

