/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.AbstractAction;
import org.opensearch.sql.opensearch.storage.scan.AggPushDownAction;
import org.opensearch.sql.opensearch.storage.scan.OSRequestBuilderAction;
import org.opensearch.sql.opensearch.storage.scan.PushDownOperation;
import org.opensearch.sql.opensearch.storage.scan.PushDownType;
import shaded.com.google.common.collect.Iterators;

public class PushDownContext
extends AbstractCollection<PushDownOperation> {
    private final OpenSearchIndex osIndex;
    private final OpenSearchRequestBuilder requestBuilder;
    private ArrayDeque<PushDownOperation> operationsForRequestBuilder;
    private boolean isAggregatePushed = false;
    private AggPushDownAction aggPushDownAction;
    private ArrayDeque<PushDownOperation> operationsForAgg;
    private boolean isLimitPushed = false;
    private boolean isProjectPushed = false;

    public PushDownContext(OpenSearchIndex osIndex) {
        this.osIndex = osIndex;
        this.requestBuilder = osIndex.createRequestBuilder();
    }

    public PushDownContext clone() {
        PushDownContext newContext = new PushDownContext(this.osIndex);
        newContext.addAll(this);
        return newContext;
    }

    public PushDownContext cloneWithoutSort() {
        PushDownContext newContext = new PushDownContext(this.osIndex);
        for (PushDownOperation action : this) {
            if (action.type() == PushDownType.SORT) continue;
            newContext.add(action);
        }
        return newContext;
    }

    @Override
    @NotNull
    public Iterator<PushDownOperation> iterator() {
        if (this.operationsForRequestBuilder == null) {
            return Collections.emptyIterator();
        }
        if (this.operationsForAgg == null) {
            return this.operationsForRequestBuilder.iterator();
        }
        return Iterators.concat(this.operationsForRequestBuilder.iterator(), this.operationsForAgg.iterator());
    }

    @Override
    public int size() {
        return (this.operationsForRequestBuilder == null ? 0 : this.operationsForRequestBuilder.size()) + (this.operationsForAgg == null ? 0 : this.operationsForAgg.size());
    }

    ArrayDeque<PushDownOperation> getOperationsForRequestBuilder() {
        if (this.operationsForRequestBuilder == null) {
            this.operationsForRequestBuilder = new ArrayDeque();
        }
        return this.operationsForRequestBuilder;
    }

    ArrayDeque<PushDownOperation> getOperationsForAgg() {
        if (this.operationsForAgg == null) {
            this.operationsForAgg = new ArrayDeque();
        }
        return this.operationsForAgg;
    }

    @Override
    public boolean add(PushDownOperation operation) {
        if (operation.type() == PushDownType.AGGREGATION) {
            this.isAggregatePushed = true;
            this.aggPushDownAction = (AggPushDownAction)operation.action();
        }
        if (operation.type() == PushDownType.LIMIT) {
            this.isLimitPushed = true;
        }
        if (operation.type() == PushDownType.PROJECT) {
            this.isProjectPushed = true;
        }
        operation.action().transform(this, operation);
        return true;
    }

    void add(PushDownType type, Object digest, AbstractAction<?> action) {
        this.add(new PushDownOperation(type, digest, action));
    }

    public boolean containsDigest(Object digest) {
        return this.stream().anyMatch(action -> action.digest().equals(digest));
    }

    public OpenSearchRequestBuilder createRequestBuilder() {
        OpenSearchRequestBuilder newRequestBuilder = this.osIndex.createRequestBuilder();
        if (this.operationsForRequestBuilder != null) {
            this.operationsForRequestBuilder.forEach((? super E operation) -> ((OSRequestBuilderAction)operation.action()).apply(newRequestBuilder));
        }
        return newRequestBuilder;
    }

    @Generated
    public OpenSearchIndex getOsIndex() {
        return this.osIndex;
    }

    @Generated
    public OpenSearchRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    @Generated
    public boolean isAggregatePushed() {
        return this.isAggregatePushed;
    }

    @Generated
    public AggPushDownAction getAggPushDownAction() {
        return this.aggPushDownAction;
    }

    @Generated
    public boolean isLimitPushed() {
        return this.isLimitPushed;
    }

    @Generated
    public boolean isProjectPushed() {
        return this.isProjectPushed;
    }
}

